/**
 * StreitwertReduktionHorcher.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Soll jede Änderung des niedrigeren Streitwerts nach Letztlich Obsiegt
 * zurückschreiben.
 * 
 * @todo TODO UnitTests!
 * 
 * @author Peter Schuster (setrok)
 * @date 27.10.2018
 *
 */
public class StreitwertReduktionHorcher implements FocusListener {
	private PanelTextFieldHandler handler;

	private long alterStreitwert = -1;

	/**
	 * Konstruktor.
	 * 
	 * @param handler {@link TeilklageruecknahmePanel}
	 */
	public StreitwertReduktionHorcher(PanelTextFieldHandler handler) {
		this.handler = handler;
	}

	/**
	 * Wenn das Textfeld den Focus bekommt: Wert zwischenspeichern, um eine Änderung
	 * erkennen zu können
	 * 
	 */
	@Override
	public void focusGained(FocusEvent fe) {
		if (handler.getFormattedTextField(TeilklageruecknahmePanel.TABLE_FTF_NACHHER) == null)
			return;
		alterStreitwert = -1;
		/* Erst gucken, ob's ein long ist */
		try {
			alterStreitwert = new NumberExtractor(
					handler.getFormattedTextField(TeilklageruecknahmePanel.TABLE_FTF_NACHHER),
					handler.getLabelText(TeilklageruecknahmePanel.TABLE_FTF_NACHHER)).extractLong();
		} catch (NumberFormatException nfe) {
			/* Sonst Änderung rückgängig */
			alterStreitwert = -1;
		}
	}

	/**
	 * Wenn das Textfeld den Focus verliert: Gucken, ob sich der Wert seit
	 * Focus-Erlangung geändert hat. Wenn ja: auch das letztliche Obsiegen ändern.
	 */
	@Override
	public void focusLost(FocusEvent fe) {
		if (handler.getFormattedTextField(TeilklageruecknahmePanel.TABLE_FTF_NACHHER) == null
				|| handler.getFormattedTextField(TeilklageruecknahmePanel.FTF_OBSIEGEN) == null)
			return;
		long neuerStreitwert = alterStreitwert;
		/* Erst gucken, ob's ein long ist */
		try {
			neuerStreitwert = new NumberExtractor(
					handler.getFormattedTextField(TeilklageruecknahmePanel.TABLE_FTF_NACHHER),
					handler.getLabelText(TeilklageruecknahmePanel.TABLE_FTF_NACHHER)).extractLong();
		} catch (NumberFormatException nfe) {
			/* Sonst Änderung rückgängig */
			neuerStreitwert = alterStreitwert;
		}
		if (neuerStreitwert != alterStreitwert) {
			handler.getFormattedTextField(TeilklageruecknahmePanel.FTF_OBSIEGEN)
					.setValue(handler.getFormattedTextField(TeilklageruecknahmePanel.TABLE_FTF_NACHHER).getValue());
		}
	}
}