/**
 * MacAboutHandler.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent.AboutEvent;
import com.apple.eawt.Application;

import eu.gronos.kostenrechner.view.menus.ExtrasJMenu;

/**
 * Klasse dient dazu, Apples "About"-Menu setzen
 *
 * @author Peter Schuster (setrok)
 * @date 26 Nov 2018
 *
 */
public class MacAboutHandler implements AboutHandler {

	static final MacAboutHandler MAC_ABOUT_HANDLER = new MacAboutHandler();

	/**
	 * Die Methode ruft {@link InfoAction#ueberKostenrechner()} als Reaktion auf
	 * "About Kostentenor" auf.
	 * 
	 * @param ae ein AboutEvent
	 * 
	 * @see com.apple.eawt.AboutHandler#handleAbout(com.apple.eawt.AppEvent.AboutEvent)
	 */
	@Override
	public void handleAbout(AboutEvent ae) {
		((InfoAction) ExtrasJMenu.getInstance().getUeberAction())//
				.ueberKostenrechner();
	}

	/**
	 * Die Methode dient dazu, Apples "About"-Menu setzen
	 * 
	 */
	public static void aboutMenuSetzen() {
		try {
			Application.getApplication().setAboutHandler(MacAboutHandler.MAC_ABOUT_HANDLER);
		} catch (NoClassDefFoundError e) {
			System.err.println("Nix can open Apple");
		}
	}

}
