/**
 * SchreibeEmailAllgemein.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;

/**
 * Die {@link Action} lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client
 * über {@link TenorUtils.emailSchreiben(String, String)} schreiben.
 * {@link KeyEvent.VK_E}
 * 
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class SchreibeEmailAllgemein extends SchreibeEmail {
	private static final long serialVersionUID = 618282849118692220L;

	/**
	 * Konstruktor.
	 * 
	 * @param beschriftung eine {@link LangBeschriftung}
	 * 
	 */
	public SchreibeEmailAllgemein(LangBeschriftung beschriftung) {
		super(beschriftung);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final String subject = "Kommentar zu kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		final String body = "Mein Kommentar zu Schusters kleinem Kostentenor:\n\n";
		if (setNoergler(
				new DatenschutzNoergler(Kostenrechner.getInstance(), DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS))
						.noergle()) {
			super.schreibe(subject, body);
			setNoergler(null);
		}
	}
}