/*

 * SchreibeEmailFehler.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Die Klasse lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client über
 * {@link TenorUtils.emailSchreiben(String, String)} schreiben. Dabei wird der
 * Text des Tenors und noch XML-Daten mitgeschickt.
 *
 * @author Peter Schuster (setrok)
 * @date 24 Apr 2019
 *
 */
public class SchreibeEmailFehler extends SchreibeEmail {
	private static final long serialVersionUID = -4095891796997774737L;
	private final FehlerHelper feHelper;

	/**
	 * 
	 * @param throwable ein {@link Throwable}, um die {@link StackTraceElement}s
	 *                  auszulesen
	 */
	public SchreibeEmailFehler(LangBeschriftung beschriftung, FehlerHelper feHelper) {
		super(beschriftung);
		this.feHelper = feHelper;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// Im E-Mail-Text wird der Stacktrace mitgeschickt.
		final String subject = "Fehlermeldung aus kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		final String fehler = super.verkleinere(feHelper.baueFehlerXmlString(false).toString());
		// Wenn dem Anhang nicht zugestimmt wird, einfache E-Mail schreiben. Bei
		// Zustimmung auch Fehlertext und StackTrace mitschicken
		schreibeDifferenziert(subject,
				"Bitte beschreiben Sie, wie es zu dem Fehler gekommen ist: " + SchreibeEmail.NEUER_ABSATZ,
				"Debug-Informationen für den Programmierer" + SchreibeEmail.NEUER_ABSATZ + fehler);
	}
}