/**
 * SchreibeEmailXml.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;

/**
 * {@link Action} lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client über
 * {@link TenorUtils.emailSchreiben(String, String)} schreiben. Dabei werden
 * XML-Daten mitgeschickt. {@link KeyEvent.VK_T}
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class SchreibeEmailXml extends SchreibeEmail {
	private static final long serialVersionUID = -4300105137631815898L;

	/**
	 * Konstruktor.
	 * 
	 * 
	 * @param beschriftung eine {@link LangBeschriftung} mit
	 *                     {@link Action#NAME},{@link Action#SHORT_DESCRIPTION},{@link Action#ACTION_COMMAND_KEY}
	 *                     und {@link Action#MNEMONIC_KEY}
	 * 
	 */
	public SchreibeEmailXml(LangBeschriftung beschriftung) {
		super(beschriftung);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final VerfahrensDatenContainer container = new XmlTransferHandler().liesAlleWertefuerContainer();
		final String subject = "Fehlverhalten in kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		// Wäre schön, wenn noch XML-Daten mitgeschickt würden.
		final String xmlString = super.verkleinere(new BerechnungXmlDatei().toXmlString(container));
		// Wenn dem Anhang nicht zugestimmt wird, einfache E-Mail schreiben. Bei
		// Zustimmung auch VerfahrensDaten als XML mitschicken
		schreibeDifferenziert(subject,
				"Wenn mit den eingegebenen Daten ein Fehler aufgetreten sein sollte, beschreiben Sie das Fehlverhalten des Programms bitte! "
						+ SchreibeEmail.NEUER_ABSATZ,
				SchreibeEmail.NEUER_ABSATZ + xmlString);
	}
}