/*
 * EmailData.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.kostenrechner.data;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Klasse um Daten fürs E-Mail-Schreiben als XML ablegen zu können
 * 
 * @author Peter Schuster (setrok)
 * @date 06.12.2020
 */
@XmlRootElement(name = "Emaildaten", namespace = "http://www.kostentenor.de/email")
@XmlType(propOrder = { "helpDeskEmail", "replaceWiths" })
public class EmailData {
	/**
	 * Die E-Mail-Adresse des Programmierers als String.
	 */
	@XmlElement
	public String helpDeskEmail;

	@XmlElement(name = "replaceWith")
	public List<Ersetzung> replaceWiths = new ArrayList<Ersetzung>();

	public EmailData() {
		super();
	}
}