/*
 * KostenZweierquote.java
 * eu.gronos.kostenrechner.data.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.data;

import eu.gronos.kostenrechner.data.tenordaten.Fraction;

/**
 * Ein Objekt zur Kostenverteilung, war ein Array double[] mit der Quote des
 * Klägers und des Beklagten, jeweils zwischen 0.0 und 1.0
 *
 * @author Peter Schuster (setrok)
 * @date 07.08.2020
 *
 */
public class KostenZweierquote {
	private final Fraction klaegerQuote;// double
	private final Fraction beklagtenQuote;// double

	/**
	 * Konstruktor:
	 * 
	 * @param klaegerQuote   {@link #getKlaegerQuote()}, war kosten[0], eine
	 *                       {@link Fraction} mit der Quote des Klägers, zwischen 0
	 *                       und 1/1
	 * @param beklagtenQuote {@link #getBeklagtenQuote()}, war kosten[1], eine
	 *                       {@link Fraction} mit der Quote des Beklagten, zwischen
	 *                       0 und 1/1
	 */ // double //double
	public KostenZweierquote(Fraction klaegerQuote, Fraction beklagtenQuote) {
		this.klaegerQuote = klaegerQuote;
		this.beklagtenQuote = beklagtenQuote;
	}

	/**
	 * Konstruktor:
	 * 
	 * @param klaegerQuote war kosten[0] mit der Quote des Klägers, eine
	 *                     {@link Fraction} zwischen 0 und 1/1, woraus die Klasse
	 *                     auch die {@link #getBeklagtenQuote()} errechnet.
	 */ // double
	public KostenZweierquote(Fraction klaegerQuote) {
		// this(klaegerQuote, 1.0 - klaegerQuote);
		this(klaegerQuote, Fraction.ONE.subtract(klaegerQuote));
	}

	/**
	 * @return gibt {@link #klaegerQuote} als {@link Fraction} zurück, war kosten[0]
	 *         mit der Quote des Klägers, zwischen 0.0 und 1.0.
	 */ // double
	public Fraction getKlaegerQuote() {
		return klaegerQuote;
	}

	/**
	 * @return gibt {@link #beklagtenQuote} als {@link Fraction} zurück, war
	 *         kosten[1] mit der Quote des Beklagten, zwischen 0.0 und 1.0.
	 */ // double
	public Fraction getBeklagtenQuote() {
		return beklagtenQuote;
	}

}
