/**
 * GerichtsKostenBeteiligter.java
 * eu.gronos.kostenrechner.logic.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.*;

/**
 * Ein {@link Beteiligter}, den {@link KostenTragungsVerhaeltnis} braucht, um
 * die Tragung von Gerichtskosten zu speichern
 *
 * @author Peter Schuster (setrok)
 * @date 11 Dec 2018
 *
 */
public class GerichtsKostenBeteiligter extends Beteiligter {
	private static final long serialVersionUID = -2204713166447254427L;

	public GerichtsKostenBeteiligter() {
		super();
		setTyp(GERICHTSKOSTEN);
		setGenusNumerus(GenusNumerus.MAENNLICH_SINGULAR);
		setLfdNr(1);
	}

	public GerichtsKostenBeteiligter(Beteiligter beteiligter) {
		this();
		setGenusNumerus(beteiligter.getGenusNumerus());
//		setGenusNumerus(beteiligter.genusNumerusAsInt());
	}

	public GerichtsKostenBeteiligter(BeteiligtenTyp typ, GenusNumerus genusNumerus) {
		this();
		setGenusNumerus(genusNumerus);
	}

//	@Deprecated
//	public GerichtsKostenBeteiligter(int typ, int genusNumerus) {
//		this();
//		setGenusNumerus(genusNumerus);
//	}

}
