package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff.AngriffArt;
import eu.gronos.kostenrechner.logic.TenorToken;

/**
 * In der Klasse lässt sich speichern, ob Klage oder Widerklage ganz
 * zugesprochen oder ganz abgewiesen wurden. Ansonsten muss ein "Im Übrigen wird
 * die (Wider-)Klage abgewiesen" an den Tenor gehängt werden.
 *
 * @author Peter Schuster (setrok)
 * @date 28.10.2021
 *
 */
public class ImUebrigen {

	private boolean vollBegruendet;
	private boolean ganzUnbegruendet;
	private AngriffArt angriffArt;

	/**
	 * Der Konstruktor lässt speichern, ob Klage bzw. Widerklage ganz zugesprochen
	 * oder ganz abgewiesen wurden
	 * 
	 * @param vollBegruendet
	 * @param ganzUnbegruendet
	 */
	public ImUebrigen(boolean vollBegruendet, boolean ganzUnbegruendet, AngriffArt angriffArt) {
		super();
		this.vollBegruendet = vollBegruendet;
		this.ganzUnbegruendet = ganzUnbegruendet;
		this.angriffArt = angriffArt;
	}

	/**
	 * 
	 * @return Zusatz für Voll- oder Teilabweisung der Klage oder Widerklage als
	 *         {@link String}
	 */
	public String toAbweisungsString() {
		if (isGanzUnbegruendet()) {
			return TenorToken.DIE.toString() + TenorToken.LEER + getAngriffArt() + TenorToken.LEER
					+ TenorToken.WIRD_ABGEWIESEN + TenorToken.PUNKT_ABSATZ;
		} else if (!isVollBegruendet()) {
			return TenorToken.IM_UEBRIGEN.toString() + TenorToken.LEER + TenorToken.WIRD_DIE + TenorToken.LEER
					+ getAngriffArt() + TenorToken.LEER + TenorToken.ABGEWIESEN + TenorToken.PUNKT_ABSATZ;
		}
		return "";
	}

	/**
	 * @return gibt {@link #vollBegruendet} als {@link boolean} zurück.
	 */
	public boolean isVollBegruendet() {
		return vollBegruendet;
	}

	/**
	 * @param vollBegruendet d. {@link #vollBegruendet}, d. gesetzt werden soll als
	 *                       {@link boolean}.
	 */
	public void setVollBegruendet(boolean vollBegruendet) {
		this.vollBegruendet = vollBegruendet;
	}

	/**
	 * @return gibt {@link #ganzUnbegruendet} als {@link boolean} zurück.
	 */
	public boolean isGanzUnbegruendet() {
		return ganzUnbegruendet;
	}

	/**
	 * @param ganzUnbegruendet d. {@link #ganzUnbegruendet}, d. gesetzt werden soll
	 *                         als {@link boolean}.
	 */
	public void setGanzUnbegruendet(boolean ganzUnbegruendet) {
		this.ganzUnbegruendet = ganzUnbegruendet;
	}

	/**
	 * 
	 * @param angriffArt d. {@link #angriffArt}, d. gesetzt werden soll als
	 *                   {@link AngriffArt}, {@link AngriffArt#KLAGE} oder
	 *                   {@link AngriffArt#WIDERKLAGE}
	 */
	public void setAngriffArt(AngriffArt angriffArt) {
		this.angriffArt = angriffArt;
	}

	/**
	 * @return gibt {@link #angriffArt} als {@link AngriffArt} zurück.
	 */
	public AngriffArt getAngriffArt() {
		return angriffArt;
	}

}
