/**
 * Widerklage.java
 * eu.gronos.kostenrechner.logic.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.baumbach;

/**
 * Die Parameterklasse speichert, ob die Widerklage vorhanden ist und ob sie
 * wirtschaftlich identisch ist.
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class Widerklage {
	private boolean vorhanden;
	private boolean wirtschaftlichIdentisch;

	/**
	 * Dieser Konstruktor übergibt alle Werte.
	 * 
	 * @param vorhanden
	 * @param wirtschaftlichIdentisch
	 */
	public Widerklage(boolean vorhanden, boolean wirtschaftlichIdentisch) {
		super();
		this.vorhanden = vorhanden;
		this.wirtschaftlichIdentisch = wirtschaftlichIdentisch;
	}

	/**
	 * Standardkonstruktor ohne Parameter
	 * 
	 */
	public Widerklage() {
		super();
	}

	/**
	 * @return gibt {@link #vorhanden} als boolean zurück.
	 */
	public boolean isVorhanden() {
		return vorhanden;
	}

	/**
	 * @param vorhanden d. {@link #vorhanden}, d. gesetzt werden soll als boolean
	 */
	public void setVorhanden(boolean vorhanden) {
		this.vorhanden = vorhanden;
	}

	/**
	 * @return gibt {@link #wirtschaftlichIdentisch} als boolean zurück.
	 */
	public boolean isWirtschaftlichIdentisch() {
		return wirtschaftlichIdentisch;
	}

	/**
	 * @param wirtschaftlichIdentisch d. {@link #wirtschaftlichIdentisch}, d.
	 *                                gesetzt werden soll als boolean
	 */
	public void setWirtschaftlichIdentisch(boolean wirtschaftlichIdentisch) {
		this.wirtschaftlichIdentisch = wirtschaftlichIdentisch;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return String.format("Widerklage [vorhanden=%b, wirtschaftlichIdentisch=%b]", vorhanden,
				wirtschaftlichIdentisch);
	}

}
