/*
 * ForderungsStaffelung.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.forderungen;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.data.tenordaten.ParteienUnterContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die
 * Registerkarte Staffelung
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class ForderungsStaffelung extends ParteienUnterContainer {
	public static final int TAB_ID = 2;
	/**
	 * forderungen speichert Hauptklageforderungen und Hilfsaufrechnungsforderungen
	 * mitsamt ihrer Höhe eingeben als {@link List}&lt;{@link Forderung}&gt;
	 */
	@XmlElements({ @XmlElement(name = "klage", type = KlageForderung.class),
			@XmlElement(name = "aufrechnung", type = AufrechnungsForderung.class) })
	@XmlElementWrapper(name = "forderungen")
	public List<Forderung> forderungen = new ArrayList<Forderung>();

	/**
	 * @return <code>true</code>, wenn {@link #forderungen} leer ist.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.UnterContainerKlasse#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return (forderungen == null || forderungen.isEmpty());
	}
}
