/*
 * GebuehrenBerechnung.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die
 * Registerkarte Freie Gebührenberechnung
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class GebuehrenBerechnung implements UnterContainerKlasse {

	public static final int TAB_ID = 3;

	/**
	 * streitwert speichert den Streitwert als {@link Euro}.
	 */
	@XmlAttribute(name = "streitwert")
	@XmlJavaTypeAdapter(EuroAdapter.class)
	public Euro streitwert;// long

	/**
	 * gebuehren speichert angefallenen Gebührentatbestände als
	 * {@link GebuehrenAuflistung}.
	 */
	@XmlElement(name = "gebuehren")
	@XmlJavaTypeAdapter(GebuehrenListAdapter.class)
	public GebuehrenAuflistung gebuehren = new GebuehrenAuflistung();

	/**
	 * 
	 * @return <code>true</code>, wenn kein {@link #streitwert} gesetzt ist und
	 *         {@link #gebuehren} leer ist.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.UnterContainerKlasse#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return (streitwert.compareTo(Euro.ZERO_CENTS) <= 0)// <= 0L
				&& (gebuehren == null || gebuehren.isEmpty());
	}
}