/*
 * GebuehrenGesetzesSammlung.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Diese Klasse hat nur den Sinn, {@link AnwaltsGebuehrenTabelle} und
 * {@link GerichtsGebuehrenTabelle} zu beherbergen.
 *
 * @author Peter Schuster (setrok)
 * @date 23.06.2019
 *
 */
public final class GebuehrenGesetzesSammlung {

	private static AnwaltsGebuehrenTabelle RVG = null;

	private static GerichtsGebuehrenTabelle GKG = null;

	/**
	 * @return gibt {@link #rvg} als {@link AnwaltsGebuehrenTabelle} zurück.
	 */
	public static AnwaltsGebuehrenTabelle getRvg() {
		if (RVG == null) {
			RVG = new AnwaltsGebuehrenTabelle();
			Kostenrechner.getLogger().info((String.format("Einlesen von rvg.xml dauerte %d ms.",
					(AnwaltsGebuehrenTabelle.end - AnwaltsGebuehrenTabelle.start))));
			System.out.println("Größe: " + RVG.getVerzeichnis().size());
		}
		return RVG;
	}

	/**
	 * @return gibt {@link #gkg} als {@link GerichtsGebuehrenTabelle} zurück.
	 */
	public static GerichtsGebuehrenTabelle getGkg() {
		if (GKG == null) {
			GKG = new GerichtsGebuehrenTabelle();
			Kostenrechner.getLogger().info((String.format("Einlesen von gkg.xml dauerte %d ms.",
					(GerichtsGebuehrenTabelle.end - GerichtsGebuehrenTabelle.start))));
			System.out.println("Größe: " + GKG.getVerzeichnis().size());
		}
		return GKG;
	}

}
