/*
 * GebuehrenVerzeichnisAdapter.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * {@link XmlAdapter} für das {@link GebuehrenAuflistung}, der nur den Zweck
 * hat, dass man die Annotations nur an einer Stelle (hier) machen muss
 *
 * @author Peter Schuster (setrok)
 * @date 26.03.2020
 *
 */
public class GebuehrenListAdapter extends XmlAdapter<GebuehrenWrapper, GebuehrenAuflistung> {

	/**
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
	 */
	@Override
	public GebuehrenAuflistung unmarshal(GebuehrenWrapper wrap) throws Exception {
		GebuehrenAuflistung verzeichnis = new GebuehrenAuflistung();
		if (wrap != null)
			verzeichnis.addAll(wrap.getList());
		return verzeichnis;
	}

	/**
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
	 */
	@Override
	public GebuehrenWrapper marshal(GebuehrenAuflistung verzeichnis) throws Exception {
		GebuehrenWrapper wrap = new GebuehrenWrapper(verzeichnis);
		return wrap;
	}

}
