package eu.gronos.kostenrechner.data.gebuehren;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;

/**
 * Informationen für jeden Verfahrensabschnitt, die dann Elemente der Liste
 * {@link StreitwertReduktionen#reduktionen} werden können, namentlich der
 * jeweilige {@link ReduktionStruktur#streitwert}, die zu diesem Wert
 * angefallenen {@link ReduktionStruktur#tatbestaende}, der
 * {@link ReduktionsGrund} in {@link ReduktionStruktur#grund} und je nach Grund
 * auch {@link ReduktionZusatzInformation} in {@link ReduktionStruktur#zusatz}.
 *
 * @author Peter Schuster (setrok)
 * @date 02.12.2021
 *
 */
public class ReduktionStruktur {
//	@XmlIDREF
	@XmlAttribute
	@XmlJavaTypeAdapter(EuroAdapter.class)
	public Euro streitwert;

	@XmlElement(name = "gebuehren")
	@XmlJavaTypeAdapter(GebuehrenListAdapter.class)
	public GebuehrenAuflistung tatbestaende = new GebuehrenAuflistung();

	@XmlAttribute(name = "grund")
	public ReduktionsGrund grund;

	@XmlElement(name = "nochWas")
	public ReduktionZusatzInformation zusatz = new ReduktionZusatzInformation();
}
