package eu.gronos.kostenrechner.data.gebuehren;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.data.tenordaten.ParteienUnterContainer;

/**
 * Der {@link ParteienUnterContainer} für Berechnungen, die
 * {@link NeueStreitwertReduktion} erweitern.
 *
 * @author Peter Schuster (setrok)
 * @date 02.12.2021
 *
 */
public class StreitwertReduktionen extends ParteienUnterContainer {

	@XmlElement(name = "wert")
	@XmlElementWrapper(name = "werte")
	@XmlJavaTypeAdapter(EuroAdapter.class)
	public List<Euro> streitwerte = new LinkedList<>();

	@XmlElement(name = "reduktion")
	@XmlElementWrapper(name = "reduktionen")
	public List<ReduktionStruktur> reduktionen = new ArrayList<>();

	@Override
	public boolean isEmpty() {
		// TODO Auto-generated method stub
		return false;
	}
}
