/*
 * Teilklageruecknahme.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.data.tenordaten.ParteienUnterContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;

/**
 * {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für die
 * Registerkarte Teilklagerücknahme (Quotenmethode, Mehrkostenmethode)
 *
 * @author Peter Schuster (setrok)
 * @date 27.12.2014
 *
 */
public class Teilklageruecknahme extends ParteienUnterContainer {

	public static final int TAB_ID = 0;

	/**
	 * streitwerteUndObsiegen speichert welchen Wert die Klage ursprünglich hatte,
	 * den verbleibenden Wert der Klage nach teilweiser Rücknahme, und in welcher
	 * Höhe der Kläger mit seiner Klage erfolgreich war als
	 * {@link List}&lt;{@link Long}&gt; mit genau 3 Elementen.
	 */
	@XmlElement(name = "wert")
	@XmlElementWrapper(name = "streitwerteUndObsiegen")
	@XmlJavaTypeAdapter(EuroAdapter.class)//(EuroListAdapter.class)
	public List<Euro> streitwerteUndObsiegen = new ArrayList<>();

	/**
	 * vorher speichert welche Gebührentatbestände vor der Reduktion angefallen
	 * waren als {@link GebuehrenAuflistung}.
	 */
	@XmlElement(name = "gebuehrenVorRuecknahme")
	@XmlJavaTypeAdapter(GebuehrenListAdapter.class)
	public GebuehrenAuflistung vorher = new GebuehrenAuflistung();

	/**
	 * nachher speichert welche Gebührentatbestände erst danach angefallen sind als
	 * {@link GebuehrenAuflistung}.
	 */
	@XmlElement(name = "gebuehrenNachRuecknahme")
	@XmlJavaTypeAdapter(GebuehrenListAdapter.class)
	public GebuehrenAuflistung nachher = new GebuehrenAuflistung();

	/**
	 * @return <code>true</code>, wenn {@link #vorher} leer ist, {@link #nachher}
	 *         leer ist und {@link #streitwerteUndObsiegen} leer ist bzw. nur Nullen
	 *         enthält
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.UnterContainerKlasse#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		HtmlRtfFormattierend zero = Euro.ofCents(0L);
		return (streitwerteUndObsiegen == null || streitwerteUndObsiegen.size() < 3//
				|| (streitwerteUndObsiegen.get(0).equals(zero) && streitwerteUndObsiegen.get(1).equals(zero)
						&& streitwerteUndObsiegen.get(2).equals(zero)))//
				&& (vorher == null || vorher.isEmpty())//
				&& (nachher == null || nachher.isEmpty());
	}

}