/*
 * Allgemein.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import java.text.DateFormat;
import java.util.Locale;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;

import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.view.KostenJPanel;

/**
 * Unterklasse von {@link VerfahrensDatenContainer} für allgemeine,
 * Registerkarten-übergreifende Einstellungen
 *
 * @author Peter Schuster (setrok)
 * @date 28.12.2014
 */
public class Allgemein implements UnterContainerKlasse {
	@XmlAttribute(name = "speicherdatum")
	public XMLGregorianCalendar speicherdatum;

	/**
	 * b92ii speichert als <code>boolean</code>, ob § 92 Abs. 2 ZPO berücksichtigt
	 * werden soll.
	 */
	@XmlAttribute(name = "p92iiZPO")
	public boolean b92ii;

	/**
	 * {@link #vomHundert92ii} speichert als <code>int</code> die Schwelle für § 92
	 * Abs. 2 ZPO, also bis zu welchem Prozentsatz das Unterliegen unwesentlich sein
	 * soll.
	 */
	@XmlAttribute(name = "p92iiZPOvH")
	public int vomHundert92ii = 10;

	/**
	 * {@link #aktenzeichen} soll als {@link String} speichern, welches Aktenzeichen
	 * das Verfahren hat. Wird derzeit nur von {@link XjustizContentHandler} genutzt
	 * und ist ansonsten ohne Funktion
	 */
	@XmlAttribute(name = "aktenzeichen")
	public String aktenzeichen;

	/**
	 * {@link #streitwert} speichert als <code>double</code> den allgemeinen
	 * Streitwert
	 */
	@XmlAttribute(name = "streitwert")
	@XmlJavaTypeAdapter(EuroAdapter.class)
	public Euro streitwert;// double

	/**
	 * {@link #selectedPanel} speichert als <code>int</code>, welches
	 * {@link KostenJPanel} beim Speichern gerade aktiv war.
	 */
	@XmlAttribute(name = "selectedPanel")
	public int selectedPanel = -1;

	/**
	 * {@code boolean}, ob Kostenquoten als Bruch dargestellt werden. Sonst werden
	 * sie als Prozent geschrieben.
	 */
	@XmlAttribute(name = "quotenAlsBruchStattProzent")
	public boolean alsBruch = false;

	/**
	 * @return immer <code>true</code>, weil keinem {@link KostenJPanel} zugeordnet.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.UnterContainerKlasse#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return true;
	}

	/**
	 * Die Methode dient dazu, die Daten aus des Untercontainers zu einem String
	 * zusammenzufassen
	 * 
	 * @return ein String
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Allgemein [");
		if (speicherdatum != null) {
			builder.append("speicherdatum=");
			builder.append(DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.GERMAN)
					.format(speicherdatum.toGregorianCalendar().getTime()));
			builder.append(", ");
		}
		if (aktenzeichen != null) {
			builder.append("aktenzeichen=");
			builder.append(aktenzeichen);
			builder.append(", ");
		}
		builder.append("b92ii=");
		builder.append(b92ii);
		builder.append(", vomHundert92ii=");
		builder.append(vomHundert92ii);
		builder.append(", streitwert=");
		builder.append(streitwert);
		builder.append(", selectedPanel=");
		builder.append(selectedPanel);
		builder.append("]");
		return builder.toString();
	}

}