/*
 * Dateikopf.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.annotation.XmlAttribute;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Unterklasse von {@link VerfahrensDatenContainer} für Programminformationen im
 * Dateikopf zu Debug-Zwecken
 *
 * @author Peter Schuster (setrok)
 * @date 28.12.2014
 */
public class Dateikopf {
	/**
	 * version speichert die Version von {@link Kostenrechner} als {@link String}.
	 */
	@XmlAttribute(name = "version")
	public String version = Kostenrechner.KOSTENRECHNER_VERSION.trim();

	/**
	 * osName speichert den Namen des Betriebssystems als {@link String}.
	 */
	@XmlAttribute(name = "osName")
	public String osName = System.getProperty("os.name");

	/**
	 * osArch speichert den Unterzweig des Betriebssystems (Operating System
	 * Architecture, etwa 32- oder 64-bit) als {@link String}.
	 */
	@XmlAttribute(name = "osArch")
	public String osArch = System.getProperty("os.arch");

	/**
	 * osVersion speichert die Version des Betriebssystems als {@link String}.
	 */
	@XmlAttribute(name = "osVersion")
	public String osVersion = System.getProperty("os.version");

	/**
	 * javaVendor speichert den Distributor von Java als {@link String}.
	 */
	@XmlAttribute(name = "javaVendor")
	public String javaVendor = System.getProperty("java.vm.vendor");

	/**
	 * javaName speichert den Namen der Java-VM als {@link String}.
	 */
	@XmlAttribute(name = "javaName")
	public String javaName = System.getProperty("java.vm.name");

	/**
	 * javaVersion speichert die Java-Version als {@link String}.
	 */
	@XmlAttribute(name = "javaVersion")
	public String javaVersion = System.getProperty("java.version");

	/**
	 * Die Methode dient dazu, die Daten des Untercontainers zu einem String
	 * zusammenzufassen
	 * 
	 * @return ein String
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Dateikopf [");
		if (version != null) {
			builder.append("version=");
			builder.append(version);
			builder.append(", ");
		}
		if (osName != null) {
			builder.append("osName=");
			builder.append(osName);
			builder.append(", ");
		}
		if (osArch != null) {
			builder.append("osArch=");
			builder.append(osArch);
			builder.append(", ");
		}
		if (osVersion != null) {
			builder.append("osVersion=");
			builder.append(osVersion);
			builder.append(", ");
		}
		if (javaVendor != null) {
			builder.append("javaVendor=");
			builder.append(javaVendor);
			builder.append(", ");
		}
		if (javaName != null) {
			builder.append("javaName=");
			builder.append(javaName);
			builder.append(", ");
		}
		if (javaVersion != null) {
			builder.append("javaVersion=");
			builder.append(javaVersion);
		}
		builder.append("]");
		return builder.toString();
	}

}