/*
 * EntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.annotation.XmlElement;

/**
 * Die Klasse dient als Marker für Unterklassen des {@link TenorDatenContainer}s
 *
 * @author Peter Schuster (setrok)
 * @date 15.02.2020
 */
public class EntscheidungsElemente {

	/**
	 * text speichert den Text der Entscheidung über die Hauptsache, die Kosten, die
	 * vorläufige Vollstreckbarkeit, den Streitwert bzw. über sonstiges oder den
	 * Text der Begründung als {@link String}.
	 */
	@XmlElement(name = "text")
	public String text;

	/**
	 * Die Methode dient der Überprüfung, ob ein importierter
	 * {@link TenorDatenContainer} überhaupt Daten enthält oder nicht (etwa, weil er
	 * mit einer alten Programmversion gespeichert wurde).
	 * 
	 * @return <code>true</code>, wenn {@link #text} nicht vorhanden ist oder wenn
	 *         er leer ist
	 */
	public boolean isEmpty() {
		return text == null || text.isEmpty();
	}
}