package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * JAXB-Adapter zur Umwandlung zwischen XML-Double-Werten wie "22.5" und
 * interner {@link Euro}-Repräsentation in Cent.
 *
 * Beispiel: 22.5 → {@link Euro#ofEuros(22.5)}
 */
public class EuroAdapter extends XmlAdapter<Double, Euro> {

	/**
	 * Die Methode macht beim Einlesen aus einem {@link Double} mit der
	 * {@link Euro#getCents()}-Angabe wieder einen {@link Euro}
	 * 
	 * @param euros die {@link Euro#ofEuros(double)}-Angabe als {@link Double}
	 * @return {@link Euro#ofEuros(double)}
	 * @throws Exception wenn es einen Fehler gab
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
	 */
	@Override
	public Euro unmarshal(Double euros) throws Exception {
		if (euros == null)
			return null;
		return Euro.ofEuros(euros);
	}

	/**
	 * Die Methode macht beim Schreiben aus einem {@link Euro} ein {@link Double}
	 * mit der {@link Euro#doubleValue()}-Angabe
	 * 
	 * @param euro den zu schreibenden {@link Euro}
	 * @return einen {@link Double} in Höhe von {@link Euro#doubleValue()}
	 * @throws Exception wenn es einen Fehler gab
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
	 */
	@Override
	public Double marshal(Euro euro) throws Exception {
		if (euro == null)
			return null;
		return Double.valueOf(euro.doubleValue());
	}

}
