package eu.gronos.kostenrechner.data.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * JAXB-Adapter zur Umwandlung zwischen List aus XML-Double-Werten wie "22.5"
 * und einer List aus interner Euro-Repräsentation in Cent.
 */
public class EuroListAdapter extends XmlAdapter<List<Double>, List<Euro>> {

	private final EuroAdapter delegate = new EuroAdapter();

	@Override
	public List<Euro> unmarshal(final List<Double> zahlen) throws Exception {
		final List<Euro> result = new ArrayList<>();
		for (Double zahl : zahlen) {
			result.add(delegate.unmarshal(zahl));
		}
		return result;

	}

	@Override
	public List<Double> marshal(final List<Euro> euros) throws Exception {
		final List<Double> result = new ArrayList<>();
		for (Euro euro : euros) {
			result.add(euro.doubleValue());
		}
		return result;
	}

}
