package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * ein {@link XmlAdapter} um einen String mit einem Bruch in eine
 * {@link Fraction} oder zurück zu konventieren. Interpretiert Zahlen zwischen
 * -1.0 und +1.0 als Dezimalbruch, andere Zahlen als Prozentangaben.
 * 
 * 
 */
public class FractionAdapter extends XmlAdapter<String, Fraction> {

	@Override
	public Fraction unmarshal(String v) throws Exception {
		if (v == null || v.isEmpty())
			return null;
		v = v.trim();

		if (v.contains("/")) {
			// Wenn der String einen Bruchstrich ("/") enthält, dann als Bruch
			// interpretieren
			final String[] parts = v.split("/");
			if (parts.length != 2)
				throw new IllegalArgumentException("Ungültiger Bruch: " + v);
			final long numerator = Long.parseLong(parts[0]), //
					denominator = Long.parseLong(parts[1]);
			return Fraction.valueOf(numerator, denominator);
		}

		// sonst ist es entweder ein Dezimalbruch zwischen 0.0 und 1.0
		// oder eine Prozentangabe
		final double parsed = Double.parseDouble(v);
		if (parsed >= -1.0 && parsed <= 1.0) {
			return Fraction.valueOf(parsed);
		} else {
			// sonst als Prozentangabe interpretieren
			return Fraction.valueOf((long) Math.round(parsed), 100L);
		}

		// wenn nix davon zutrifft, schleudert der Parser halt eine Exception.

	}

	@Override
	public String marshal(Fraction v) throws Exception {
		return v.toString();
	}

}
