/*
 * ParteienUnterContainer.java
 * eu.gronos.kostenrechner.model.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;

/**
 * Eine {@link UnterContainerKlasse}, die bereits die {@link List} der Parteien
 * als {@link Beteiligter} speichert.
 *
 * @author Peter Schuster (setrok)
 * @date 26.03.2020
 *
 */
public abstract class ParteienUnterContainer implements UnterContainerKlasse {

	/**
	 * parteien speichert das Geschlecht von Kläger und/oder Beklagtem bzw., dass es
	 * mehrere Kläger/Beklagte gibt als {@link List}&lt;{@link Beteiligter}&gt;
	 */
	@XmlElement(name = "partei")
	@XmlElementWrapper(name = "parteien")
	public List<Beteiligter> parteien = new ArrayList<Beteiligter>();

}