package eu.gronos.kostenrechner.data.tenordaten;

/**
 * Der {@link Enum} beschreibt den Typ eines Tenors
 *
 * @author Peter Schuster (setrok)
 * @date 01.12.2021
 *
 */
public enum TenorTyp {
	PROZESS, HAUPTSACHE, KOSTEN, VOLLSTRECKUNG;

	/**
	 * Die Methode liefert den passenden TenorTyp zu einem Prozessverhältnis, also
	 * {@link #HAUPTSACHE} bei einem {@link HauptsacheVerhaeltnis}, {@link #KOSTEN}
	 * bei einem {@link KostenTragungsVerhaeltnis} und {@link #VOLLSTRECKUNG} bei
	 * einem {@link VollstreckungsVerhaeltnis}.
	 * 
	 * @param verhaeltnis das {@link ProzessVerhaeltnis}
	 * @return den passenden {@link TenorTyp} oder {@link #PROZESS}, falls keiner
	 *         von den genannten Typen.
	 */
	public static TenorTyp of(ProzessVerhaeltnis verhaeltnis) {
		if (verhaeltnis instanceof VollstreckungsVerhaeltnis) {
			return VOLLSTRECKUNG;
		}
		if (verhaeltnis instanceof KostenTragungsVerhaeltnis) {
			return KOSTEN;
		}
		if (verhaeltnis instanceof HauptsacheVerhaeltnis) {
			return HAUPTSACHE;
		}
		return PROZESS;
	}
}
