package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;

/**
 * Ein Interface für Klassen, die sich sowohl für RTF- als auch für HTML-Zwecke
 * formatiert darstellen können.
 * 
 * Typische Anwendungsfälle: - HTML: JTable mit HTML-Renderer (geschütztes
 * Leerzeichen als &nbsp;) - RTF: RTF-Dokumente mit \~ als geschütztem
 * Leerzeichen
 * 
 * Das Interface dient insbesondere dazu, Beträge wie {@link Euro} oder
 * {@link Fraction}s in typografisch korrekter Form darzustellen.
 * 
 * Beispiel:
 * 
 * - toString(): "23,00 €" - toHtmlString(): "23,00&nbsp;€" - toRtfString():
 * "23,00\\~€"
 */
public interface HtmlRtfFormattierend {

	/**
	 * Gibt eine typografisch korrekte RTF-Darstellung zurück, z. B. mit geschütztem
	 * Leerzeichen vor dem Eurozeichen oder typografisch gemalten Brüchen
	 * 
	 * @return {@link #toString()} mit geschütztem Leerzeichen und €
	 */
	String toRtfString();

	/**
	 * Gibt eine HTML-taugliche Darstellung zurück, z. B. mit &nbsp; vor dem
	 * Eurozeichen oder typografisch gemalten Brüchen
	 *
	 * 
	 * @return {@link #toString()} mit geschütztem Leerzeichen und €
	 */
	String toHtmlString();

}