/*
 * PanelTextFieldHandler.java
 * eu.gronos.kostenrechner.view.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Das Interface hilft einer {@link BeschriebeneAktion}, sich mit dem
 * {@link KostenJPanel} über {@link JFormattedTextField}s auszutauschen.
 *
 * @author Peter Schuster (setrok)
 * @date 16 Apr 2019
 *
 */
public interface PanelTextFieldHandler {

	/**
	 * Die Methode dient dazu, das passende {@link JFormattedTextField}
	 * zurückzuliefern
	 * 
	 * @param index ein Bezeichner für das {@link JFormattedTextField}, z.B.
	 *              {@link GebuehrenBerechnungPanel#TABLE_FTF_GEBUEHREN},
	 *              {@link TeilklageruecknahmePanel#TABLE_FTF_VORHER} oder
	 *              {@link TeilklageruecknahmePanel#TABLE_FTF_NACHHER}
	 * @return gibt das gewählte {@link JFormattedTextField} zurück.
	 */
	public JFormattedTextField getFormattedTextField(int index);


	/**
	 * Die Methode soll den Text des zum {@link JFormattedTextField} gehörenden
	 * {@link JLabel}s zurückgeben.
	 * 
	 * @param index ein Bezeichner für das {@link JFormattedTextField}, z.B.
	 *              {@link GebuehrenBerechnungPanel#TABLE_FTF_GEBUEHREN},
	 *              {@link TeilklageruecknahmePanel#TABLE_FTF_VORHER} oder
	 *              {@link TeilklageruecknahmePanel#TABLE_FTF_NACHHER}
	 * @return das {@link JLabel#getText()} als String
	 */
	public String getLabelText(int index);

}