/*
 * Pruefend.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Das Interface soll eine Klass im package util ermöglichen, den ein
 * {@link ParsendUndBauend} oder ein {@link TenorVorbereitend} nutzen können.
 * Der {@link ParsendUndBauend} kann dann erst alle Bausteine einlesen und dann
 * mit {@link #pruefeEingabe(Object)} alle nötigen Werte prüfen lassen und dabei
 * Plausibilitäten checken.
 * 
 * Die implementierende Klasse soll ohne einen {@link HinzufuegenDialog}
 * funktionieren, der seinerseits nur mit dem {@link ParsendUndBauend} bzw.
 * dem {@link TenorVorbereitend} kommuniziert.
 *
 * @author Peter Schuster (setrok)
 * @date 16.07.2020
 *
 */
public interface Pruefend<E> {

	/**
	 * Die Methode wird aufgerufen, um zu prüfen, ob der Rückgabewert gültige
	 * Teilwerte hat, die zueinander nicht im Widerspruch stehen.
	 * 
	 * @param eingabe ein {@link Object} (E) von generischen Typ der Klasse
	 * @return <code>true</code>, wenn die Plausibilitäten zufrieden sind
	 */
	public boolean pruefeEingabe(E eingabe)
			throws IllegalArgumentException, NumberFormatException, NullPointerException;
}
