/**
 * Tenorierend.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

/**
 * Das Interface schreibt Klassen vor, eine Methode String erzeugeTenor() zu
 * implementieren. Es schreibt Klassen jetzt auch vor, mit {@link #getGruende()}
 * Gründe zu liefern. Dadurch zeichnet es Klassen aus, die zur Tenorfindung
 * gebaut sind und so z.B. in eine GUI eingebaut werden können.
 * 
 * @author Peter Felix Schuster (setrok)
 * @date 21.08.2014
 */
public interface Tenorierend {

	/**
	 * Die Methode erzeugeTenor dient dazu, einen Tenor zu erzeugen, der auch nur
	 * aus dem Kostentenor bestehen kann.
	 * 
	 * @return den Tenortext als String.
	 */
	abstract String erzeugeTenor();

	/**
	 * Die Methode soll eine Beschreibung für die Art des Tenor zurückgeben, damit
	 * andere Klassen etwa das Dokument danach benennen können.
	 * 
	 * @return eine Beschreibung als String, z.B. "Tenor nach Baumbachscher
	 *         Kostenformel"
	 */
	abstract String getTenorBeschreibung();

	/**
	 * Die Methode soll eine Begründung für den Tenor zurückgeben, vor allem für den
	 * Kostentenor.
	 * 
	 * @return den Text Gründe/Entscheidungsgründe als String
	 */
	abstract String getGruende();
}