/**
 * TooltipHandler.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JComponent;

/**
 * Ein Interface, damit Tablemodels Tooltips für Spaltenüberschriften anzeigen
 * können
 * 
 * @author Peter Felix Schuster (setrok)
 * @date 11.08.2014
 */
public interface TooltipLieferant {

	/**
	 * Die Methode gibt den TooltipText für die angegebene Spalte zurück. So
	 * können Renderer ihn als TooltipText setzen, z.B.. mit
	 * {@link JComponent#setToolTipText(String)}.
	 * 
	 * @param columnIndex
	 *            die abgefragte Spalte
	 * @return den TooltipText als String
	 */
	String getTooltipText(int columnIndex);
}
