/**
 * UnterKlasse.java
 * eu.gronos.kostenrechner.controller (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.view.KostenJPanel;

/**
 * Die leere Klasse dient als Marker für UnterContainer des
 * VerfahrensDatenContainers, damit die Unterklassen in Generics genutzt werden
 * können.
 *
 * @author Peter Schuster (setrok)
 * @date 22.06.2018
 *
 */
public interface UnterContainerKlasse {
	// nur als Marker

	/**
	 * Die Methode dient dazu, den beim Speichern aktiven {@link KostenJPanel}
	 * herauszufinden, wenn er nicht mitgespeichert wurde. Sie soll herausfinden, ob
	 * der Nutzer Werte gesetzt hat.
	 * 
	 * @return <code>true</code>, wenn im korrespondierenden Panel keine Werte sind,
	 *         <code>false</code>, wenn ein Wert gesetzt ist. Klassen, die keinem
	 *         Panel zugeordnet sind, liefern immer <code>true</code>.
	 */
	public boolean isEmpty();
}