/**
 * 
 */
package eu.gronos.kostenrechner.logic;

import eu.gronos.kostenrechner.interfaces.EnumString;

/**
 * Verschiedene Konstanten zum Erstellen von Tenor, Gründen usw.
 *
 * @author Peter Schuster (setrok)
 * @date 11.11.2021
 *
 */
public enum TenorToken implements EnumString<TenorToken> {
	// aus StreitwertReduktion
	GRUENDE_EINLEITUNG_91("§ 91 ZPO."), GRUENDE_EINLEITUNG_92("§§ 91, 92 ZPO und "),
	GRUENDE_EINLEITUNG_92_269("§§ 91, 92, 269 Abs. 3 ZPO und "),

	// aus MehrkostenMethode
	GRUENDE_BERECHNUNG_MEHRKOSTEN(
			"Danach ist bei einer teilweisen Klagerücknahme die Kostenquote dadurch zu ermitteln, dass die durch den zurückgenommenen Teil entstandenen Mehrkosten in Relation zu den tatsächlich entstandenen Kosten des Rechtsstreits zu setzen sind. "),
	GRUENDE_EINLEITUNG_TABELLE("Im einzelnen errechnen sich diese Punkte wie folgt"),
	WEITER_GRUENDE_MEHRK("der sogenannten Mehrkostenmethode"),

	// aus QuotenMethode
	WEITER_GRUENDE_QUOTENM("der sogenannten Quotenmethode."),

	// aus TenorTexter
	KOSTENTRAGUNG_SELBST("Im Übrigen haben die Parteien ihre außergerichtlichen Kosten selbst zu tragen"),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709(
			"Das Urteil ist gegen Sicherheitsleistung in Höhe von 110% des jeweils zu vollstreckenden Betrags vorläufig vollstreckbar"),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_1(
			" wird nachgelassen, die Vollstreckung gegen Sicherheitsleistung in Höhe von " + "110%"
					+ " des aufgrund des Urteils vollstreckbaren Betrags abzuwenden, wenn nicht "),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_2(" vor der Vollstreckung Sicherheit in Höhe von " + "110%"
			+ " des jeweils zu vollstreckenden Betrags leistet"),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR("Das Urteil ist vorläufig vollstreckbar"),
	JEWEILIGER_VOLLSTRECKUNGSGLAEUBIGER("der jeweilige Vollstreckungsgläubiger"),
	JEWEILIGER_VOLLSTRECKUNGSSCHULDNER("dem jeweiligen Vollstreckungsschuldner"),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_WERIST_1(
			" nachgelassen, die Vollstreckung gegen Sicherheitsleistung in Höhe von 110%"
					+ " des aufgrund des Urteils vollstreckbaren Betrags abzuwenden, wenn nicht "),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_WERIST_2(
			" vor der Vollstreckung Sicherheit in Höhe von 110%" + " des jeweils zu vollstreckenden Betrags leistet"),
	URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709_EINZELN(
			" ist es gegen Sicherheitsleistung in Höhe von 110% des jeweils zu vollstreckenden Betrags vorläufig vollstreckbar"),

	// aus BaumbachFormel
	GRUENDE_91_92_100II("§§ 91, 92, 100 Abs. 2 ZPO" + " und der sogenannten Baumbach'schen Kostenformel,"
			+ " entsprechend der unterschiedlichen Beteiligung am Rechtsstreit"),

	ABGEWIESEN("abgewiesen"), AN("an"), AUF("auf"), AUF_DIE_WIDERKLAGE("Auf die Widerklage"),
	AUSSERGERICHTLICHEN_KOSTEN("außergerichtlichen Kosten"), DARUEBER_HINAUS("darüber hinaus"),
	DAVON_FD_KLAGE("davon für die Klage "), DIE("Die"), DIE_GERICHTSKOSTEN("Die Gerichtskosten"),
	DIE_KOSTEN_DES_RECHTSSTREITS("Die Kosten des Rechtsstreits"), DOPPELPUNKT_ABSATZ(":\n"),
	ERGEBNIS_ZEILE("Kostenquote hinsichtlich eines fiktiven Streitwerts von "), EURO("EUR"),
	FESTGESETZT("festgesetzt."), FUER("Für"), GEGEN("gegen"), GEGENUEBER("gegenüber"),
	GESAMTSCHULDNERISCH("gesamtschuldnerisch"), GRUENDE_EINLEITUNG("Die Kostenentscheidung beruht auf "),
	HABEN("haben"),
	HINSICHTLICH_DES_JEWEILIGEN_VOLLSTRECKUNGSVERHAELTNISSES("Hinsichtlich des jeweiligen Vollstreckungsverhältnisses"),
	IM_UEBRIGEN("Im Übrigen"), KOMMA_LEER(", "), KOPFZEILE_BEGINN("Einzelangriffe / Verluste"), LEER(" "),
	PUNKT_ABSATZ(".\n"), STREITWERT_WIRD_AUF("Der Streitwert wird auf"), UND_DIE("und die"),
	UND_FD_WIDERKLAGE("und für die Widerklage"), VERLUST_GESAMT("Verlust gesamt"), VERURTEILT("verurteilt"),
	VS(" ./. "), WIRD("wird"), WIRD_ABGEWIESEN("wird abgewiesen"), WIRD_DIE("wird die"), ZU("zu"),
	ZU_TRAGEN("zu tragen"), ZU_ZAHLEN("zu zahlen"),
	GRUENDE_VERBLIEBENER_GEGENSTAND_SONST(", ist auch das Unterliegen diesbezüglich zu berücksichtigen. "),
	GRUENDE_VERBLIEBENER_GEGENSTAND(
			"Da die Klage hinsichtlich des verbliebenen Streitgegenstands nicht vollständig erfolgreich war");

	private final String token;

	TenorToken(String token) {
		this.token = token;
	}

	@Override
	public String toString() {
		return token;
	}

}
