/*
 * AngriffsTexter.java
 * eu.gronos.kostenrechner.logic.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.logic.forderungen;

import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.Casus.DATIV;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.Casus.NOMINATIV;

import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.logic.TenorTexter;

/**
 * Die Klasse verfasst die Tenortexte für
 * {@link AngriffsVerteidigungsmittelStaffelung}
 *
 * @author Peter Schuster (setrok)
 * @date 4 Jun 2019
 *
 */
public class AngriffsTexter extends TenorTexter<ForderungsStaffelung> {

	public AngriffsTexter(boolean alsBruch) {
		super(alsBruch);
	}

	private Euro ganz;

	@Override
	public String texteHauptsache(EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache) {
		String tenor;
		final HauptsacheVerhaeltnis verhaeltnis = hauptsache.prozessverhaeltnisse.get(0);
		// if (verhaeltnis.getVerurteilung() > 0) {
		if (verhaeltnis.getVerurteilung().greaterThan(Euro.ZERO_CENTS)) {
			tenor = satzBeginn(String.format(TenorTexter.VERURTEILUNGS_FORMAT_EUR,
					verhaeltnis.getSchuldner().parteiBezeichner(NOMINATIV, verhaeltnis.getSchuldner().getLfdNr(), true),
					verhaeltnis.getGlaeubiger().parteiBezeichner(DATIV, verhaeltnis.getGlaeubiger().getLfdNr(), true),
					verhaeltnis.getVerurteilung()));// (double)
			// if (ganz > verhaeltnis.getVerurteilung())
			if (ganz.greaterThan(verhaeltnis.getVerurteilung())) /* wenn nicht vollständig obsiegt oder verloren */
				tenor += TenorTexter.KLAGEABWEISUNG_IM_UEBRIGEN;
		} else
			tenor = TenorTexter.KLAGEABWEISUNG;
		tenor += "\n";
		return tenor;
	}

	@Override
	public String texteStreitwert(StreitwertEntscheidungsElemente elemente) {
		return String.format(TenorTexter.STREITWERT_FESTGESETZT_EUR, elemente.streitwerte.get(0));// (double)
	}

	/**
	 * @param euro d. {@link #ganz}, d. gesetzt werden soll als {@link Euro}.
	 */
	public void setGanz(Euro euro) {
		this.ganz = euro;
	}

}
