package eu.gronos.kostenrechner.util.baumbach;

import java.util.List;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.AngriffListe;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.Pruefend;

/**
 * Ein {@link Pruefend} für die {@link AngriffListe}
 *
 * @author Peter Schuster (setrok)
 * @date 25.11.2021
 *
 */
public class AngriffListePruefer implements Pruefend<List<Angriff>> {

	@Override
	public boolean pruefeEingabe(List<Angriff> angriffe) throws IllegalArgumentException, NullPointerException {

		AngriffPruefer angriffePruefer = new AngriffPruefer();

		// Der Erfolg darf zusammengenommen nicht den Antrag überschreiten, also...
		// Angriffe gruppieren ...
		final List<List<Angriff>> gruppen = AngriffListe.gruppiereAngriffe(angriffe);
		for (List<Angriff> gruppe : gruppen) {
			final Euro einheitlicherAntrag = AngriffListe.findeEinheitlichenAntrag(gruppe);
			for (Angriff angriff : gruppe) {
				// ... zunächst Angriff selbst prüfen ...
				angriffePruefer.pruefeEingabe(angriff);
				// ... und gucken, dass Gesamt-Erfolg nicht den Antrag überschreitet.
				if (einheitlicherAntrag.getCents() >= 0L && angriff.getGegner().size() == 1
						&& AngriffListe.findeGanzenErfolg(gruppe, angriff.getAngreifer(), angriff.getGegner())
								.getCents() > einheitlicherAntrag.getCents()) {
					throw new IllegalArgumentException(
							"Die gesamtschuldnerische Verurteilung und die Verurteilung darüber hinaus dürfen zusammen nicht den Antrag überschreiten.");
				}
			}
		}

		// Ohne Fehler ist alles gut!
		return true;
	}

}
