package eu.gronos.kostenrechner.util.baumbach;

import java.util.Comparator;

import eu.gronos.kostenrechner.data.baumbach.GerichtsKostenBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.MehrfachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;

/**
 * Die Klasse vergleicht zwei {@link Beteiligter} und schiebt
 * {@link GerichtsKostenBeteiligter} nach oben
 *
 * @author Peter Schuster (setrok)
 * @date 09.11.2021
 *
 */
public class BeteiligteInAngreiferGegnerReihenfolge implements Comparator<Beteiligter> {

	/**
	 * Die Methode vergleicht zwei {@link Beteiligter} und schiebt
	 * {@link GerichtsKostenBeteiligter} nach oben. Dabei geht sie zuerst nach
	 * {@link Beteiligter#getTyp()} (wobei {@link GerichtsKostenBeteiligter} immer
	 * vor alle anderen kommt), dann nach {@link Beteiligter#getLfdNr()}
	 * 
	 * @param bet1 erster {@link Beteiligter}
	 * @param bet2 zweiter {@link Beteiligter}
	 * @return -1, wenn bet1<bet2, 0, wenn bet1==bet2, 1, wenn bet1>bet2
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(Beteiligter bet1, Beteiligter bet2) {
		// Wenn die Objekte gleich sind, 0 zurückgeben
		if (bet1.equals(bet2))
			return 0;
		// Nur wenn die Typen identisch sind, auf die Laufende Nummer abstellen
		if (bet1.getTyp() == bet2.getTyp()) {
			/*
			 * MehrfachBeteiligter nach vorn und bei mehreren MehrfachBeteiligten absteigend
			 * nach Anzahl sortieren
			 */
			if (bet1 instanceof MehrfachBeteiligter && bet2 instanceof MehrfachBeteiligter) {
				return Integer.compare(((MehrfachBeteiligter) bet2).size(), ((MehrfachBeteiligter) bet1).size()
//						((MehrfachBeteiligter) bet2).beteiligte.size(),
//						((MehrfachBeteiligter) bet1).beteiligte.size()
				);
			} else if (bet1 instanceof MehrfachBeteiligter) {
				return -1;
			} else if (bet2 instanceof MehrfachBeteiligter) {
				return 1;
			}
			// an Integer.compare(x, y) delegieren
			return Integer.compare(bet1.getLfdNr(), bet2.getLfdNr());
		} else {
			// Wenn die Typen ungleich sind, Gerichtskosten nach vorne
			if (bet1 instanceof GerichtsKostenBeteiligter)
				return -1;
			else if (bet2 instanceof GerichtsKostenBeteiligter)
				return 1;
			// Wenn die Typen ungleich sind, auf diese abstellen
			return // Integer.compare(bet1.getTyp(), bet2.getTyp());
			bet1.getTyp().compareTo(bet2.getTyp());
		}
	}

}
