/*
 * WiderklagePruefer.java
 * eu.gronos.kostenrechner.util.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.view.baumbach.WiderklageHinzufuegenDialog;

/**
 * Ein {@link Pruefend} für den {@link WiderklageHinzufuegenDialog}
 *
 * @author Peter Schuster (setrok)
 * @date 17.07.2020
 *
 */
public class WiderklagePruefer implements Pruefend<Widerklage> {

	/**
	 * Die Methode wird aufgerufen, um zu prüfen, ob der Rückgabewert gültige
	 * Teilwerte hat, die zueinander nicht im Widerspruch stehen. Prüft nicht viel.
	 * Wirtschaftlich identisch ohne aktivierte Widerklage sinnlos.
	 * 
	 * @param eingabe eine {@link Widerklage}
	 * @return <code>true</code>, wenn die Plausibilitäten zufrieden sind
	 * @throws IllegalArgumentException Wirtschaftlich identisch ohne aktivierte
	 *                                  Widerklage sinnlos.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Pruefend#pruefeEingabe(java.lang.Object)
	 */
	@Override
	public boolean pruefeEingabe(Widerklage eingabe) throws IllegalArgumentException, NullPointerException {
		if (eingabe.isWirtschaftlichIdentisch() && !eingabe.isVorhanden()) {
			throw new IllegalArgumentException(
					"Wirtschaftliche Identität wird nicht beachtet, wenn keine Widerklage aktiviert ist.");
		}
		return true;
	}

}
