/**
 * ParserUtil.java
 * eu.gronos.kostenrechner.util (Kostenrechner)
 */
package eu.gronos.kostenrechner.util.system;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;

/**
 * Die Klasse stellt Methoden bereit, um die Programmparameter zu parsen.
 * 
 * Die Methode {@link #parseDateiname()} prüft, ob eine existierende Datei
 * übergeben wurde. Die Methode {@link #parseDebug()} sucht nach dem Parameter
 * -debug.
 * 
 * @todo TODO UnitTests
 *
 * @author Peter Schuster (setrok)
 * @date 06.09.2018
 *
 */
public class ArgumentParser {

	/**
	 * DEBUG speichert den Parameter, um den Debug-Modus zu aktivieren als {@link String}.
	 */
	private static final String DEBUG = "-debug";
	private final String[] args;

	/**
	 * Konstruktor:
	 * 
	 * @param args der String[] mit den Aufrufparametern aus
	 *             {@link Kostenrechner#main(String[]) main}
	 * 
	 */
	public ArgumentParser(String[] args) {
		super();
		this.args = args;
	}

	/**
	 * Die Methode prüft, ob eine Xjustiz-XML-Datei als Parameter zum Programmaufruf
	 * angegeben wurde oder eine Berechnungs-SKKTX-Datei
	 * 
	 * @return eine Datei als {@link Path} oder <code>null</code>, wenn keine
	 *         existierende Datei übergeben wurde
	 */
	public Path parseDateiname() {
		for (int i = 0; i < args.length; i++) {
			Path datei = null;
			datei = Paths.get(args[i]);//new File(args[i]);
			/* Prüfen nach Endung XML oder SKKTX */
			if (BerechnungXmlDatei.DATEI_FILTER.acceptExtension(datei)
					|| XjustizContentHandler.XJUSTIZ_FILTER.acceptExtension(datei)) {
				if (Files.exists(datei))//(datei.exists())
					return datei;
			} else {
				datei = Paths.get(args[i] + BerechnungXmlDatei.DATEI_FILTER.ganzeEndung());
				if (Files.exists(datei))//(datei.exists())
					return datei;
				datei = Paths.get(args[i] + XjustizContentHandler.XJUSTIZ_FILTER.ganzeEndung());
				if (Files.exists(datei))//(datei.exists())
					return datei;
			}
		}
		return null;
	}

	/**
	 * Die Methode prüft, ob das das Programm mit Schalter -debug aufgerufen wurde.
	 * 
	 * Vorsicht: die Methode wird aufgerufen, bevor es eine GUI gibt.
	 * 
	 * @return true, wenn debug
	 */
	public boolean parseDebug() {
		if (args != null && args.length > 0)
			for (String s : args) {
				if (DEBUG.equalsIgnoreCase(s)) {
					return true;
				}
			}
		return false;
	}

}
