/*
 * KostenTableRenderer.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;

/**
 * ein von {@link JLabel} abgeleiteter Renderer für {@link TableCellRenderer}
 *
 * @author Peter Schuster (setrok)
 * @date 20.07.2019
 *
 */
public abstract class KostenTableRenderer extends JLabel {

	private static final long serialVersionUID = -7819198135827152595L;
	private Farbwelt farbwelt = new Farbwelt("Table");

	public KostenTableRenderer() {
		super();
	}

	/**
	 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend gesetzt werden.
	 * Sonst die Zelle nach dem normalen Vorder- und Hintergrund einfärben.
	 */
	protected void setSelected(boolean isSelected) {
		setOpaque(true);
		if (isSelected) {
			this.setBackground(farbwelt.selectionBackground);
			this.setForeground(farbwelt.selectionForeground);
		} else {
			this.setBackground(farbwelt.background);
			this.setForeground(farbwelt.foreground);
		}
	}

}