/**
 * RechnerhammerIcons.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view;

import java.awt.Image;
import java.util.ArrayList;

import javax.swing.ImageIcon;

/**
 * Setzt die Programmicons. Als Singleton gebaut.
 *
 * @author Peter Schuster (setrok)
 * @version
 * @date 24.06.2018
 *
 */
public class RechnerhammerIcons extends ArrayList<Image> {
	private static final long serialVersionUID = -4678326774497761406L;
	private static RechnerhammerIcons instance = new RechnerhammerIcons();

	/**
	 * Der Konstruktor ist private nach Singleton-Muster, tut aber nichts.
	 * 
	 */
	private RechnerhammerIcons() {
		super();
	}

	/**
	 * Die Methode dient dazu, die PNG-Bilddateien aus dem Resource-Ordner zu laden.
	 * 
	 */
	public void loadIcons() {
		add(loadIcon("resources/rechnerhammer-16.png").getImage());
		add(loadIcon("resources/rechnerhammer-20.png").getImage());
		add(loadIcon("resources/rechnerhammer-32.png").getImage());
		add(loadIcon("resources/rechnerhammer-40.png").getImage());
		add(loadIcon("resources/rechnerhammer-64.png").getImage());
		add(loadIcon("resources/rechnerhammer-80.png").getImage());
		add(loadIcon("resources/rechnerhammer-96.png").getImage());
		add(loadIcon("resources/rechnerhammer-128.png").getImage());
		add(loadIcon("resources/rechnerhammer-256.png").getImage());
		add(loadIcon("resources/rechnerhammer-512.png").getImage());
	}

	/**
	 * Die Methode lädt eine einzelne PNG-Bilddateien aus dem Resource-Ordner.
	 * 
	 * @param name den Pfad zur Bilddatei im Resource-Ordner
	 * 
	 * @return ein {@link ImageIcon}
	 */
	public static ImageIcon loadIcon(String name) {
		ImageIcon icon = new ImageIcon(RechnerhammerIcons.class.getClassLoader().getResource(name));
		icon.setDescription(name);
		return icon;
	}

	/**
	 * Die Methode gibt einen roten Rechnerhammer für Fehlermeldungen zurück
	 * 
	 * @return ein {@link ImageIcon}
	 */
	public static ImageIcon getRechnerhammerRot() {
		return loadIcon("resources/rechnerhammer-rot.png");
	}

	/**
	 * Die Methode gibt den Rechnerhammer in 64x64 für Dialogbilder zurück
	 * 
	 * @return ein {@link ImageIcon}
	 */
	public static ImageIcon getRechnerhammer64() {
		return loadIcon("resources/rechnerhammer-64.png");
	}

	/**
	 * Die Methode gibt den Rechnerhammer in 256x256 für Dialogbilder zurück
	 * 
	 * @return ein {@link ImageIcon}
	 */
	public static ImageIcon getRechnerhammer128() {
		return loadIcon("resources/rechnerhammer-128.png");
	}

	/**
	 * @return gibt {@link #instance} als RechnerhammerIcons zurück.
	 */
	public static RechnerhammerIcons getInstance() {
		return instance;
	}
}
