/**
 * BeteiligtenHinzufuegenDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.baumbach;

import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.KLAEGER;

import java.awt.Frame;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.controller.baumbach.BeteiligtenParser;
import eu.gronos.kostenrechner.controller.baumbach.WiderklageCheckboxTextfieldHorcher;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Dialog zum Hinzufügen eines (einfachen) BaumbachBeteiligten
 * 
 */
public class BeteiligtenHinzufuegenDialog extends HinzufuegenDialog<BaumbachBeteiligter> {

	private static final long serialVersionUID = 2242125254034647717L;
	JComboBox<Beteiligter> cmbTypGenusNumerus;
	JCheckBox cbAnWiderklageBeteiligt;
	JFormattedTextField ftfStreitwert;
	JFormattedTextField ftfUnterliegen;
	final BeteiligtenTyp beteiligtenTyp;// int
	final boolean widerKlageAnzeigen;
	private BaumbachBeteiligter beteiligter;
	private JLabel lblStreitwert;
	private JLabel lblUnterliegen;
	private ParsendUndBauend<BaumbachBeteiligter> pruefer = new BeteiligtenParser();

	/**
	 * Create the dialog.
	 * 
	 * @param owner              the JFrame from which the dialog is displayed
	 * @param beteiligter        ein BaumbachBeteiligter mit den voreingestellten
	 *                           Werten für den Beteiligtentyp, Genus, Numerus,
	 *                           Streitwert, Unterliegen und ob er an der Widerklage
	 *                           beteiligt ist.
	 * @param widerKlageAnzeigen wenn true, werden zusätzliche Felder für die
	 *                           Widerklage angezeigt
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#HinzufuegenDialog(JFrame,String)
	 * @see javax.swing.JDialog#JDialog(Frame,String,boolean)
	 */
	public BeteiligtenHinzufuegenDialog(JFrame owner, BaumbachBeteiligter beteiligter, boolean widerKlageAnzeigen) {
		super(owner,
				(Beschriftung) new ComponentBeschrifter().changeTo(
						((Vorsorgend<?>) NameContainerSammlung.BESCHRIFTUNGEN.get(35000)),
						beteiligter.getTyp().ordinal()));// beteiligtenTypAsInt
		this.widerKlageAnzeigen = widerKlageAnzeigen;
		this.beteiligter = beteiligter;
		this.beteiligtenTyp = beteiligter.getTyp();
	}

	/**
	 * Methode zum Plausis checken, wird vom OK-Button aufgerufen.
	 * 
	 * @return true, wenn alle Plausis eingehalten werden
	 */
	@Override
	public boolean parseEingabe() {
		return pruefer.leseComponents(cmbTypGenusNumerus, cbAnWiderklageBeteiligt, ftfStreitwert, ftfUnterliegen)
				.parseEingabe();
	}

	/**
	 * @return beteiligtenTyp gibt den beteiligtenTyp als int zurück.
	 */
	BeteiligtenTyp getBeteiligtenTyp() {
		return beteiligtenTyp;
	}

	/**
	 * Die Methode füllt den Inhaltsbereich des Dialogs mit den Eingabe- und
	 * Auswahlkomponenten
	 * 
	 */
	@Override
	protected void fuelleContentPane() {
//		JLabel lblBeteiligtentyp = (JLabel) toContentPanel(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(35001));
		cmbTypGenusNumerus = fillBeteiligtenCombo(beteiligtenTyp);
		togetherToContentPanel(cmbTypGenusNumerus, (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(35005));
//		lblBeteiligtentyp.setLabelFor(cmbTypGenusNumerus);

		cbAnWiderklageBeteiligt = (JCheckBox) toContentPanel(new JCheckBox(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(35011));
		cbAnWiderklageBeteiligt.setSelected(beteiligter.isAnWiderklageBeteiligt());
		/*
		 * Die CheckBox soll nicht erscheinen, wenn Widerklagen nicht angezeigt werden.
		 * Der BeteiligtenPruefer nimmt sich daraus die Info, ob Widerklagen angezeigt
		 * werden sollen.
		 */
		cbAnWiderklageBeteiligt.setVisible(widerKlageAnzeigen);

//		lblStreitwert = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(35021));
		ftfStreitwert = (JFormattedTextField) toContentPanel(lblStreitwert = new JLabel(),
				new JFormattedTextField(formatter), (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(35025));
		ftfStreitwert.setText(String.valueOf(beteiligter.getAntrag().doubleValue()));// (Double.toString(beteiligter.getAntrag()));
		setEnterAction(ftfStreitwert, getOkAction());
		if (!widerKlageAnzeigen && beteiligtenTyp == KLAEGER) {
			ftfStreitwert.setText("0");
			lblStreitwert.setVisible(false);
			ftfStreitwert.setVisible(false);
		}
//		lblStreitwert.setLabelFor(ftfStreitwert);

//		lblUnterliegen = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(35031));
		ftfUnterliegen = (JFormattedTextField) toContentPanel(lblUnterliegen = new JLabel(),
				new JFormattedTextField(formatter), (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(35035));
		ftfUnterliegen.setText(String.valueOf(beteiligter.getErfolg().doubleValue()));// (Double.toString(beteiligter.getErfolg()));
		setEnterAction(ftfUnterliegen, getOkAction());
		if (!widerKlageAnzeigen && beteiligtenTyp == KLAEGER) {
			ftfUnterliegen.setText("0");
			lblUnterliegen.setVisible(false);
			ftfUnterliegen.setVisible(false);
		}
//		lblUnterliegen.setLabelFor(ftfUnterliegen);

//		.add(
//		beschrifter.testUnVergittert(contentPanel, lblBeteiligtentyp,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, cmbTypGenusNumerus,
//				GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, cbAnWiderklageBeteiligt,
//				GitterBeutelBeschraenkungen.getInstance(2, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblStreitwert,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, ftfStreitwert,
//				GitterBeutelBeschraenkungen.getInstance(1, 2, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblUnterliegen,
//				GitterBeutelBeschraenkungen.getInstance(0, 3, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, ftfUnterliegen,
//				GitterBeutelBeschraenkungen.getInstance(1, 3, 2, 1, GridBagConstraints.HORIZONTAL, false));

		final WiderklageCheckboxTextfieldHorcher horcher = new WiderklageCheckboxTextfieldHorcher(cmbTypGenusNumerus,
				cbAnWiderklageBeteiligt, ftfStreitwert, ftfUnterliegen,
				(VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(35011));
		cmbTypGenusNumerus.addItemListener(horcher);
		cbAnWiderklageBeteiligt.addChangeListener(horcher);
		// Sonst gibt es IndexOutOfBounds!
		cmbTypGenusNumerus.setSelectedIndex(beteiligter.getGenusNumerus().getGenus().ordinal());
		// % Beteiligter.PLURAL);
		horcher.stateChanged(new ChangeEvent(this));
		horcher.itemStateChanged(null);
	}

//	private Component toContentPanel(Component das, NameContainer damit) {
//		return beschrifter.beschrifteVergittert				(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(35021), contentPanel);
//	}

	@Override
	protected BaumbachBeteiligter baueRueckgabewert() {
		return pruefer.leseComponents(cmbTypGenusNumerus, cbAnWiderklageBeteiligt, ftfStreitwert, ftfUnterliegen)
				.getRueckgabewert();
	}

	/**
	 * Die Methode fillBeteiligtenCombo dient dazu, eine JComboBox mit Beteiligten
	 * eines Typs zu füllen
	 * 
	 * @param beteiligtenTyp
	 * @return
	 */
	private JComboBox<Beteiligter> fillBeteiligtenCombo(BeteiligtenTyp beteiligtenTyp) {
		Beteiligter[] beteiligtenAuswahlListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(beteiligtenTyp, false);
		JComboBox<Beteiligter> jComboBox = new JComboBox<Beteiligter>(beteiligtenAuswahlListe);
		jComboBox.setEnabled(true);
		jComboBox.setEditable(false);
		jComboBox.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
		return jComboBox;
	}

}
