/**
 * GesamtschuldnerDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.baumbach;

import java.awt.Frame;

import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.kostenrechner.controller.baumbach.GesamtschuldParser;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenExtractAndCancelAction;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenListModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Dialog zum Hinzufügen eines BaumbachGesamtschuldners
 * 
 * @author Peter Schuster (setrok)
 * @date 16.06.2014
 */
public class GesamtschuldnerDialog extends HinzufuegenDialog<BaumbachGesamtschuldnerschaft> {
	private static final long serialVersionUID = 7906671533792996231L;
	private final BeschriebeneAktion extrahierenAction;// AbstractAction

	private BaumbachBeteiligtenListe baumbachBeteiligtenListe;
//	private JScrollPane scpBeteiligtenAuswahlListe;

	private JList<BaumbachBeteiligter> beteiligtenAuswahlListe;

	private JFormattedTextField ftfUnterliegen;
	private ParsendUndBauend<BaumbachGesamtschuldnerschaft> pruefer = new GesamtschuldParser();

	/**
	 * Erzeugt einen modalen Dialog zum Hinzufügen eines Gesamtschuldners
	 * 
	 * @param owner the JFrame from which the dialog is displayed
	 * @param kl    die BaumbachBeteiligtenListe mit den Klägern
	 * @param dwbk  die BaumbachBeteiligtenListe mit den Drittwiderbeklagten, zu der
	 *              ein Beteiligter hinzugefügt werden soll
	 */
	public GesamtschuldnerDialog(JFrame owner, BaumbachBeteiligtenListe kl, BaumbachBeteiligtenListe dwbk,
			BeschriebeneAktion extrahierenAction) {
		this(owner, new BaumbachBeteiligtenListe(kl, dwbk), extrahierenAction);
	}

	/**
	 * Erzeugt einen modalen Dialog zum Hinzufügen eines Gesamtschuldners
	 * 
	 * @param owner                    the JFrame from which the dialog is displayed
	 * @param baumbachBeteiligtenListe die BaumbachBeteiligtenListe, zu der ein
	 *                                 Beteiligter hinzugefügt werden soll
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#HinzufuegenDialog(JFrame,String)
	 * @see javax.swing.JDialog#JDialog(Frame, String, boolean)
	 * @throws IllegalArgumentException wenn die
	 *                                  <code>baumbachBeteiligtenListe</code> leer
	 *                                  ist
	 */
	public GesamtschuldnerDialog(JFrame owner, BaumbachBeteiligtenListe baumbachBeteiligtenListe,
			BeschriebeneAktion extrahierenAction) throws IllegalArgumentException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(36000));
		if (baumbachBeteiligtenListe.size() < 1)
			throw new IllegalArgumentException("Keine Beteiligten für den angegebenen Beteiligtentyp vorhanden, "
					+ "\ndie gesamtschuldnerisch verurteilt werden könnten. "
					+ "\nBitte zunächst \"einfache\" Beteiligte der Liste hinzufügen.");
		else
			this.baumbachBeteiligtenListe = baumbachBeteiligtenListe;
		LangBeschriftung beschriftung = (LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(36031);
		beschriftung.setActionCommandKey((String) extrahierenAction.getValue(Action.ACTION_COMMAND_KEY));
		this.extrahierenAction = new StreitgenossenExtractAndCancelAction(beschriftung, extrahierenAction,
				super.getCancelAction());
	}

	/**
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		return pruefer.leseComponents(beteiligtenAuswahlListe, ftfUnterliegen).parseEingabe();
	}

	/**
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected BaumbachGesamtschuldnerschaft baueRueckgabewert() {
		return pruefer.leseComponents(beteiligtenAuswahlListe, ftfUnterliegen).getRueckgabewert();
	}

	/**
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
//		JLabel lblBeteiligtentyp = (JLabel) toContentPanel(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(36001));
		beteiligtenAuswahlListe = new JList<BaumbachBeteiligter>(new BeteiligtenListModel(baumbachBeteiligtenListe));
		beschrifter.beschrifte(beteiligtenAuswahlListe, NameContainerSammlung.BESCHRIFTUNGEN.get(36011));
		beteiligtenAuswahlListe.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		beteiligtenAuswahlListe.setCellRenderer(new BeteiligtenListRenderer());
//		scpBeteiligtenAuswahlListe = (JScrollPane) 
		togetherToContentPanel(new JScrollPane(beteiligtenAuswahlListe),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(36010));
//		lblBeteiligtentyp.setLabelFor(scpBeteiligtenAuswahlListe);

//		JLabel lblUnterliegen = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(36021));
		ftfUnterliegen = (JFormattedTextField) togetherToContentPanel(new JFormattedTextField(formatter),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(36025));
		ftfUnterliegen.setText(getLetztenBeteiligten().getErfolg().toString());// (Double.toString(getLetztenBeteiligten().getErfolg()));
		ftfUnterliegen.setColumns(10);
		setEnterAction(ftfUnterliegen, getOkAction());
//		lblUnterliegen.setLabelFor(ftfUnterliegen);
//		lblUnterliegen.setHorizontalAlignment(SwingConstants.RIGHT);

//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblBeteiligtentyp,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, scpBeteiligtenAuswahlListe,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.BOTH, true));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblUnterliegen,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, ftfUnterliegen,
//				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));

//		getButtonPane().add(new JButton(extrahierenAction));
//		addToRootInputMap(extrahierenAction);
		toButtonPanel(extrahierenAction);
	}

	/**
	 * Die Methode greift den letzten Eintrag aus der übergebenen
	 * baumbachBeteiligtenListe
	 * 
	 * @return
	 */
	private BaumbachBeteiligter getLetztenBeteiligten() {
		return this.baumbachBeteiligtenListe.get(this.baumbachBeteiligtenListe.size() - 1);
	}
}
