package eu.gronos.kostenrechner.view.baumbach;

import java.text.NumberFormat;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import javax.swing.text.NumberFormatter;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.model.baumbach.ScalableBeteiligtenTableModel;
import eu.gronos.kostenrechner.view.EuroEditor;
import eu.gronos.kostenrechner.view.EuroRenderer;

/**
 * Eine einfache Erweiterung von JTable, um Beteiligtendaten anzuzeigen und zu
 * bearbeiten
 */
public class SimpleBeteiligtenTable extends JTable {
	private static final long serialVersionUID = -8877232808960976183L;
	private static NumberFormat format = NumberFormat.getInstance();
	static {
		format.setGroupingUsed(false);
	}
	private static NumberFormatter formatter = new NumberFormatter(format);
	private BeteiligtenTyp beteiligtenTyp;// int

	/**
	 * Setzt das {@link TableModel} für die {@link JTable} und dabei auch eine
	 * schöne Breite für die Spalten.
	 * 
	 * @param dm ein {@link ScalableBeteiligtenTableModel}
	 * 
	 * @see javax.swing.JTable#setModel(javax.swing.table.TableModel)
	 * @see #setWidth()
	 */
	@Override
	public void setModel(TableModel dm) {
		super.setModel(dm);
		if (dm != null && dm instanceof ScalableBeteiligtenTableModel) {
			setEditors();
			setRenderers();
			setWidth();
		}
	}

	/**
	 * Setzt die Standardwerte für Auswahlmodus usw.
	 * 
	 */
	public void setSelectionModel() {
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		setRowSelectionAllowed(true);
		setColumnSelectionAllowed(false);
	}

	/**
	 * Setzt eine angenehme Breite für die erste Spalte
	 * 
	 */
	public void setWidth() {
		if (isEmpty())
			return;
		int maxWidth = getColumnModel().getColumn(1).getWidth() / 2;
		if (maxWidth < getColumnModel().getColumn(1).getMinWidth())
			maxWidth = getColumnModel().getColumn(1).getMinWidth();
		getColumnModel().getColumn(0).setMaxWidth(maxWidth);
	}

	/**
	 * Eine einfache Erweiterung von JTable, um Beteiligtendaten anzuzeigen und zu
	 * bearbeiten
	 * 
	 * @param beteiligtenTyp eine der Konstanten {@link Beteiligter#KLAEGER},
	 *                       {@link Beteiligter#BEKLAGTE} oder
	 *                       {@link Beteiligter#DRITTWIDERBEKLAGTE}
	 */ // int
	protected SimpleBeteiligtenTable(BeteiligtenTyp beteiligtenTyp) {
		super();
		this.beteiligtenTyp = beteiligtenTyp;
	}

	/**
	 * Eine einfache Erweiterung von JTable, um Beteiligtendaten anzuzeigen und zu
	 * bearbeiten
	 * 
	 * @param dm             ein {@link ScalableBeteiligtenTableModel}
	 * @param beteiligtenTyp eine der Konstanten {@link Beteiligter#KLAEGER},
	 *                       {@link Beteiligter#BEKLAGTE} oder
	 *                       {@link Beteiligter#DRITTWIDERBEKLAGTE}
	 */ //int
	protected SimpleBeteiligtenTable(TableModel dm, BeteiligtenTyp beteiligtenTyp) {
		this(beteiligtenTyp);
		setModel(dm);
	}

	private void setEditors() {
		setDefaultEditor(Beteiligter.class, new BeteiligtenCellEditor(beteiligtenTyp));
		setDefaultEditor(Double.class, new EuroEditor(formatter));
	}

	private void setRenderers() {
		setDefaultRenderer(Beteiligter.class, new BeteiligtenTableRenderer());
		setDefaultRenderer(Double.class, new EuroRenderer());
	}

	private boolean isEmpty() {
		return getModel() == null || getModel().getRowCount() < 1;
	}

}
