/**
 * WiderklageHinzufuegenDialog.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.baumbach;

import java.awt.HeadlessException;

import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.baumbach.WiderklageParser;
import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein kleiner {@link HinzufuegenDialog} für {@link Widerklage}, der auch nach
 * wirtschaftlicher Identität fragt
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class WiderklageHinzufuegenDialog extends HinzufuegenDialog<Widerklage> {
	private static final long serialVersionUID = -9111863513392608271L;
	private JCheckBox chbWiderklage;
	private JCheckBox chbWirtschaftlichIdentisch;
	private ParsendUndBauend<Widerklage> pruefer = new WiderklageParser();

	/**
	 * Konstruktor.
	 * 
	 * @param owner ein {@link JFrame}, im Zweifel ein Verweis auf
	 *              {@link Kostenrechner}, wird von {@link JDialog} für modale
	 *              Fenster gebraucht
	 * @param title der {@link String} für den Titel.
	 */
	public WiderklageHinzufuegenDialog(JFrame owner) throws HeadlessException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(37000));
	}

	@Override
	public boolean parseEingabe() {
		return pruefer.leseComponents(chbWiderklage, chbWirtschaftlichIdentisch).parseEingabe();
	}

	/**
	 * Die Methode baut ein {@link Widerklage}-Objekt aus den Werten der beiden
	 * {@link JCheckBox}-Elemente des Dialogs
	 * 
	 * @return ein Objekt {@link Widerklage}
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected Widerklage baueRueckgabewert() {
		final Widerklage rueckgabewert = pruefer.leseComponents(chbWiderklage, chbWirtschaftlichIdentisch)
				.getRueckgabewert();
		return rueckgabewert;
	}

	@Override
	protected void fuelleContentPane() {
		// beschrifter.beschrifteVergittert, contentPanel
		chbWiderklage = (JCheckBox) toContentPanel(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(37001));
		chbWiderklage.setSelected(true);

		// beschrifter.beschrifteVergittert, contentPanel
		chbWirtschaftlichIdentisch = (JCheckBox) toContentPanel(new JCheckBox(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(37011));
		chbWirtschaftlichIdentisch.setSelected(false);

//		.add(
//		beschrifter.testUnVergittert(contentPanel, chbWiderklage,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, chbWirtschaftlichIdentisch,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
	}

}