/**
 * ForderungHinzufuegen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.forderungen;

import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.kostenrechner.controller.forderungen.ForderungParser;
import eu.gronos.kostenrechner.data.forderungen.AufrechnungsForderung;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.KlageForderung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein HinzufügenDialog für Forderungen
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2014
 *
 */
public class ForderungHinzufuegen extends HinzufuegenDialog<Forderung> {

	private static final long serialVersionUID = 7212266450545525463L;

	private JComboBox<Forderung> cmbForderungsart;
	private JFormattedTextField ftfStreitwert;
	private JFormattedTextField ftfUnterliegen;
	private final ParsendUndBauend<Forderung> pruefer = new ForderungParser();

	/**
	 * Konstruktor erzeugt den Dialog
	 * 
	 * @param owner der aufrufende JFrame
	 */
	public ForderungHinzufuegen(JFrame owner) {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(45000));
	}

	/**
	 * Die Methode gibt ein Array von Forderungen für JComboBox
	 * 
	 * @return ein Array Forderung[] mit einer KlageForderung und einer
	 *         AufrechnungsForderun
	 */
	public static Forderung[] sammleForderungen() {
		return new Forderung[] { new KlageForderung(Euro.ZERO_CENTS, Euro.ZERO_CENTS),
				new AufrechnungsForderung(Euro.ZERO_CENTS, Euro.ZERO_CENTS) };
	}

	/**
	 * Die Methode wird von okAction aufgerufen, um zu prüfen, ob alle JComponents
	 * zur Eingabe mit gültigen Werten gefüllt sind und diese zueinander nicht im
	 * Widerspruch stehen.
	 * 
	 * @return true, wenn sich die Werte in den Feldern Höhe und Begründetheit
	 *         parsen lassen und der Erfolg nicht höher als der Wert ist.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		pruefer.leseComponents(cmbForderungsart, ftfStreitwert, ftfUnterliegen);
		return pruefer.parseEingabe();
	}

	/**
	 * Die Methode füllt das contentPanel mit einer JComboBox, je einem
	 * JFormattedTextField für Streitwert und Erfolg sowie dazugehörigen JLabels.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
//		JLabel lblForderungsart = (JLabel) toContentPanel(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(45011));

		cmbForderungsart = new JComboBox<Forderung>(sammleForderungen());
		togetherToContentPanel(cmbForderungsart, (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(45015));
		cmbForderungsart.setRenderer(new ForderungenRenderer());
//		lblForderungsart.setLabelFor(cmbForderungsart);

//		JLabel lblWert = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(45021));
		ftfStreitwert = (JFormattedTextField) togetherToContentPanel(new JFormattedTextField(formatter),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(45025));
		ftfStreitwert.setText(Double.toString(0));
		setEnterAction(ftfStreitwert, getOkAction());
//		lblWert.setLabelFor(ftfStreitwert);

//		JLabel lblErfolg = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(45031));
		ftfUnterliegen = (JFormattedTextField) togetherToContentPanel(new JFormattedTextField(formatter),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(45035));
		ftfUnterliegen.setText(Double.toString(0));
		setEnterAction(ftfUnterliegen, getOkAction());
//		lblErfolg.setLabelFor(ftfUnterliegen);

//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblForderungsart,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, cmbForderungsart,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblWert,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, ftfStreitwert,
//				GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, lblErfolg,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//		beschrifter.testUnVergittert(contentPanel, ftfUnterliegen,
//				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
	}

	/**
	 * Die Methode dient dazu, aus den Eingabefeldern des Dialogs einen Rückgabewert
	 * zusammenzubauen, der dann von showDialog() an die aufrufende Maske
	 * zurückgegeben werden kann.
	 * 
	 * @return eine Forderung in der gewählten Höhe
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected Forderung baueRueckgabewert() {
		pruefer.leseComponents(cmbForderungsart, ftfStreitwert, ftfUnterliegen);
		return pruefer.getRueckgabewert();
	}
}