/**
 * AufrechnungPanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.forderungen;

import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.BEKLAGTE;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.KLAEGER;

import java.awt.GridBagLayout;

import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.forderungen.ForderungNeuAction;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungParser;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungTenorAction;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.forderungen.ForderungenTableModel;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;

/**
 * Diese von {@link KostenJPanel} abgeleitete Klasse nimmt die
 * Oberflächenelemente für die Forderungsstaffelung auf.
 *
 * @author Peter Schuster (setrok)
 * @date 13.06.2018
 *
 */
public class ForderungsStaffelungPanel extends KostenJPanel implements WerteLesbar<ForderungsStaffelung> {

	private static final long serialVersionUID = 1506079463701863627L;
	private static final ForderungsStaffelungPanel instance = new ForderungsStaffelungPanel();
	private Kostenrechner kostenrechner;
	public JComboBox<Beteiligter> cbAngriffsKlaeger;
	public AbstractAction neueForderungAction = new ForderungNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(42021));// , KeyEvent.VK_H
	public AbstractAction angriffsVerteidigungsmittelStaffelungAction = new ForderungsStaffelungTenorAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(43011));
	public JComboBox<Beteiligter> cbVerteidigungsBeklagter;
	public ForderungenTableModel ftm;
	public JTable tbForderungen;
	private static final ForderungenRenderer FORDERUNGEN_RENDERER = new ForderungenRenderer();
	private final ParsendUndBauend<ForderungsStaffelung> pruefer = new ForderungsStaffelungParser();

	/**
	 * Der Konstruktor ruft nur die Oberklasse auf.
	 * 
	 */
	private ForderungsStaffelungPanel() {
		super();
	}

	/**
	 * @return gibt {@link #instance} als AufrechnungPanel zurück.
	 */
	public static ForderungsStaffelungPanel getInstance() {
		return instance;
	}

	/**
	 * Die Methode setzt die Oberflächenelemente für die Registerkarte 3
	 * Hilfsaufrechnung.
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JPanel pnParteien = super.addNewPanel// createPanel
		((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(41000), new GridBagLayout());

//		JLabel lblKlBezeichner = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(41001), pnParteien);
//		lblKlBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);
		Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(KLAEGER, true);
		// Sonst gibt es Warnungen bei der expliziten Typkonversion
		cbAngriffsKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
		beschrifter.beschrifteGemeinsam(cbAngriffsKlaeger,
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(41005), pnParteien);
		cbAngriffsKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
//		lblKlBezeichner.setLabelFor(cbAngriffsKlaeger);

//		JLabel lblBkBezeichner = (JLabel) 
//		beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(41011), pnParteien);
//		lblBkBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(BEKLAGTE, true);
		// Sonst gibt es Warnungen bei der expliziten Typkonversion
		cbVerteidigungsBeklagter = new JComboBox<Beteiligter>(bkBezeichnerListe);
		beschrifter.beschrifteGemeinsam(cbVerteidigungsBeklagter,
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(41015), pnParteien);
		cbVerteidigungsBeklagter.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);

		JPanel pnForderungen = super.addNewPanel// createPanel
		((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(42000), new GridBagLayout());
//		JLabel lblForderungen = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(42001), pnForderungen);

		tbForderungen = (JTable) beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(42011));
		leereWerte();
		entferneTastaturFalle(tbForderungen);
		tbForderungen.setDefaultRenderer(Forderung.class, ForderungsStaffelungPanel.FORDERUNGEN_RENDERER);
		tbForderungen.setDefaultRenderer(Double.class, KostenJPanel.EURO_RENDERER);
		tbForderungen.setDefaultEditor(Double.class, KostenJPanel.EURO_EDITOR);
		JComboBox<Forderung> cbForderungen = new JComboBox<Forderung>(ForderungHinzufuegen.sammleForderungen());
		cbForderungen.setRenderer(ForderungsStaffelungPanel.FORDERUNGEN_RENDERER);
		tbForderungen.setDefaultEditor(Forderung.class, new DefaultCellEditor(cbForderungen));
		tbForderungen.getTableHeader().setDefaultRenderer(KostenJPanel.HEADER_RENDERER);

//		JScrollPane scpForderungen = (JScrollPane) 
		beschrifter.beschrifteGemeinsam(new JScrollPane(tbForderungen),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(42010), pnForderungen);
//		lblForderungen.setLabelFor(scpForderungen);

//		JButton btnNeueForderung = .toButton()
		beschrifter.add((BeschriebeneAktion) neueForderungAction, pnForderungen);

//		JButton btnAngriffsVerteidigungsmittelStaffelung = 		.toButton();
		beschrifter.add((BeschriebeneAktion) angriffsVerteidigungsmittelStaffelungAction, this);

//		.add(
//		beschrifter.testUnVergittert(pnParteien, lblKlBezeichner,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnParteien.add(
//		beschrifter.testUnVergittert(pnParteien, cbAngriffsKlaeger,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnParteien.add(
//		beschrifter.testUnVergittert(pnParteien, lblBkBezeichner,
//				GitterBeutelBeschraenkungen.getInstance(2, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnParteien.add(
//		beschrifter.testUnVergittert(pnParteien, cbVerteidigungsBeklagter,
//				GitterBeutelBeschraenkungen.getInstance(3, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, pnParteien,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));

//		.add
//		beschrifter.testUnVergittert(pnForderungen, lblForderungen,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnForderungen.add(
//		beschrifter.testUnVergittert(pnForderungen, scpForderungen,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.BOTH, false));
//		pnForderungen.add(
//		beschrifter.testUnVergittert(pnForderungen, btnNeueForderung,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, pnForderungen,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 3, GridBagConstraints.BOTH, false));

//		add(
//		beschrifter.testUnVergittert(this, btnAngriffsVerteidigungsmittelStaffelung,
//				GitterBeutelBeschraenkungen.getInstance(0, 5, 2, 1, GridBagConstraints.HORIZONTAL, false));

		final PopupMenuBuilder builder = new PopupMenuBuilder();
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(44000), tbForderungen,
				new Integer[] { 1 }, (BeschriebeneAktion) neueForderungAction,
				(BeschriebeneAktion) eintragEntfernenAktion);

		logDauer();
	}

	/**
	 * Die Methode leert die Tabelle mit den Forderungen und ersetzt mit denen aus
	 * dem {@link ForderungsStaffelung}-Behälter. Zudem werden
	 * {@link #cbAngriffsKlaeger} und {@link #cbVerteidigungsBeklagter} angepasst.
	 * 
	 * @param staffelung {@link ForderungsStaffelung}
	 *
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#setzeWerte(java.lang.Object)
	 */
	@Override
	public void setzeWerte(final ForderungsStaffelung container) {
		cbAngriffsKlaeger.setSelectedItem(container.parteien.get(0));
		cbVerteidigungsBeklagter.setSelectedItem(container.parteien.get(1));
		ftm = new ForderungenTableModel();
		ftm.setAllValues(container.forderungen);
		tbForderungen.setModel(ftm);
	}

	/**
	 * Die Methode leert die Tabelle mit den Forderungen.
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	public void leereWerte() {
		if (tbForderungen != null) {
			ftm = new ForderungenTableModel();
			tbForderungen.setModel(ftm);
		}
	}

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return den Untercontainer von {@link VerfahrensDatenContainer#staffelung}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public ForderungsStaffelung baueRueckgabewert() {
		pruefer.leseComponents(cbAngriffsKlaeger, cbVerteidigungsBeklagter, tbForderungen).parseEingabe();
		return pruefer.getRueckgabewert();
	}

	/**
	 * Die Methode dient dazu, eine Referenz auf das Hauptfenster zu übermitteln
	 * 
	 * @param kostenrechner
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 */
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

}