/**
 * GebuehrHinzufuegenDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.gebuehren;

import java.awt.Frame;

import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.controller.gebuehren.AuslagenHoeheVisibilityHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenDocumentHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenParser;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenVerzeichnis;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenListModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Dialog zum Hinzufügen eines Gebührentatbestands (oder Auslagentatbestands)
 * 
 * @author Peter Schuster (setrok)
 * @date 16.06.2014
 */
public class GebuehrHinzufuegenDialog extends HinzufuegenDialog<GebuehrenTatbestand> {
	private static final long serialVersionUID = 6033596324746359222L;
	private JFormattedTextField ftfAuslagenHoehe;
	private JLabel lblGebuehrenListe;
	private JLabel lblAuslagenHoehe;
	private GebuehrenVerzeichnis alleGebTb;
	private JList<GebuehrenTatbestand> liGebuehrenListe;
	private final GebuehrenParser pruefer = new GebuehrenParser();

	/**
	 * Der Standardkonstruktor baut einen Dialog, bei dem aus den übergegebenen
	 * Gebührentatbeständen ausgewählt werden kann.
	 * 
	 * @param owner        der JFrame, der den Dialog aufrufen soll
	 * @param beschriftung eine {@link Beschriftung}, mit dem der anzuzeigende Titel
	 *                     {@link JDialog#getTitle()} gesetzt wird
	 * @param alleGebTb    ein {@link GebuehrenVerzeichnis} mit den
	 *                     GebuehrenTatbeständen, die zur Auswahl stehen soll.
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#HinzufuegenDialog(JFrame,
	 *      String)
	 * @see javax.swing.JDialog#JDialog(Frame,String,boolean)
	 */
	public GebuehrHinzufuegenDialog(JFrame owner, Beschriftung beschriftung, GebuehrenVerzeichnis alleGebTb) {
		super(owner, beschriftung);
		this.alleGebTb = alleGebTb;
	}

	/**
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		pruefer.leseComponents(ftfAuslagenHoehe, liGebuehrenListe, lblAuslagenHoehe);
		return pruefer.parseEingabe();
	}

	/**
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		final GebuehrenListModel model = new GebuehrenListModel();
		model.addAll(alleGebTb);

//		JLabel lblSuchfeld = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(16001));
//		lblSuchfeld.setHorizontalAlignment(SwingConstants.RIGHT);
		final JTextField tfSuchfeld = (JTextField) togetherToContentPanel(new JTextField(),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(16005));
		tfSuchfeld.getDocument().addDocumentListener(new GebuehrenDocumentHorcher(model));
//		lblSuchfeld.setLabelFor(tfSuchfeld);
		setEnterAction(tfSuchfeld, getOkAction());

		lblGebuehrenListe = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(16011));
//		lblGebuehrenListe.setHorizontalAlignment(SwingConstants.LEFT);
		liGebuehrenListe = new JList<GebuehrenTatbestand>();
		beschrifter.beschrifte(liGebuehrenListe, NameContainerSammlung.BESCHRIFTUNGEN.get(16021));

		liGebuehrenListe.setModel(model);
		liGebuehrenListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		liGebuehrenListe.setSelectedIndex(0);
		liGebuehrenListe.setCellRenderer(new GebuehrenListRenderer());
//		JScrollPane scpGebuehrenListe = (JScrollPane) beschrifter.beschrifte
		toContentPanel(new JScrollPane(liGebuehrenListe), NameContainerSammlung.BESCHRIFTUNGEN.get(16020));
		lblGebuehrenListe.setLabelFor(liGebuehrenListe);

//		lblAuslagenHoehe = (JLabel) toContentPanel(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(16031));
//		lblAuslagenHoehe.setHorizontalAlignment(SwingConstants.RIGHT);

		ftfAuslagenHoehe = (JFormattedTextField) toContentPanel(lblAuslagenHoehe = new JLabel(),
				new JFormattedTextField(formatter), (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(16035));
		setEnterAction(ftfAuslagenHoehe, getOkAction());
//		lblAuslagenHoehe.setLabelFor(ftfAuslagenHoehe);

//		beschrifter.testUnVergittert(contentPanel, lblSuchfeld,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(contentPanel, tfSuchfeld,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(contentPanel, lblGebuehrenListe,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(contentPanel, scpGebuehrenListe,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 1, GridBagConstraints.BOTH, true));
//		beschrifter.testUnVergittert(contentPanel, lblAuslagenHoehe,
//				GitterBeutelBeschraenkungen.getInstance(0, 3, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(contentPanel, ftfAuslagenHoehe,
//				GitterBeutelBeschraenkungen.getInstance(1, 3, 1, 1, GridBagConstraints.HORIZONTAL, false));

		final AuslagenHoeheVisibilityHorcher listener = new AuslagenHoeheVisibilityHorcher(ftfAuslagenHoehe,
				lblAuslagenHoehe, (VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(16031));
		liGebuehrenListe.addListSelectionListener(listener);
		model.addListDataListener(listener);
		listener.valueChanged(new ListSelectionEvent(liGebuehrenListe, 0, 1, false));
	}

	/**
	 * Die Methode showDialog dient dazu, den Dialog aufzurufen, auf eine Eingabe zu
	 * warten und dann einen GebuehrenTatbestand (bzw. AuslagenTatbestand)
	 * zurückzugeben.
	 * 
	 * @return einen GebuehrenTatbestand (GebuehrenSatzTatbestand bzw.
	 *         AuslagenTatbestand) mit den Werten der Komponenten
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected GebuehrenTatbestand baueRueckgabewert() {
		pruefer.leseComponents(ftfAuslagenHoehe, liGebuehrenListe, lblAuslagenHoehe);
		GebuehrenTatbestand gt = pruefer.getRueckgabewert();
		return gt;
	}
}
