/**
 * GebuehrenPanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.gebuehren;

import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrNeuAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenAufstellungAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenBerechnungAufrufHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenBerechnungParser;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenSetzeRechnerTabelleAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenStreitwertHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTabelleDruckenAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTabelleKopierenAction;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.gebuehren.StreitwertTableModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJPanel;

/**
 * Diese von {@link KostenJPanel} abgeleitete Klasse nimmt die
 * Oberflächenelemente für die Gebührenberechnung auf.
 *
 * @author Peter Schuster (setrok)
 * @date 13.06.2018
 *
 */
public class GebuehrenBerechnungPanel extends KostenJPanel
		implements WerteLesbar<GebuehrenBerechnung>, GebuehrenTableTextfieldHandler {
	private static final String SUMME_EUR = "Summe: %,.2f EUR";
	private static final long serialVersionUID = -8251865293845494552L;
	private static final GebuehrenBerechnungPanel instance = new GebuehrenBerechnungPanel();
	private Kostenrechner kostenrechner;
	private JTable tabStreitwertTabelle;
	private JFormattedTextField ftfStreitwert;
	public JTable tabGebuehrenTatbestaende;
	private JTextField tfGebuehrenSumme;
	public GebuehrenTableModel gttmRechner;

	private final AbstractAction neueGkgGebuehrAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(22021), TABLE_GEBUEHREN,
			GebuehrNeuAction.GKG_KEY);
	private final AbstractAction neueRvgVerguetungAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(22031), TABLE_GEBUEHREN,
			GebuehrNeuAction.RVG_KEY);
	private final AbstractAction gebuehrenAufstellungAction = new GebuehrenAufstellungAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(23031));
	public final AbstractAction normaleGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24221),
			GebuehrenSetzeRechnerTabelleAction.GEBUEHREN_STANDARD);
	public final AbstractAction saeumnisGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24211),
			GebuehrenSetzeRechnerTabelleAction.GEBUEHREN_SAEUMNIS);
	public final AbstractAction anerkenntnisGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24215),
			GebuehrenSetzeRechnerTabelleAction.GEBUEHREN_ANERKENNTNIS);
	private final AbstractAction mitInstanzGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24225),
			GebuehrenSetzeRechnerTabelleAction.GEBUEHREN_2INSTANZ);
	private final AbstractAction druckeSwTabelleAction = new GebuehrenTabelleDruckenAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24111));
	private final AbstractAction kopiereSwTabelleAction = new GebuehrenTabelleKopierenAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24101));
	private final AllzweckHorcher aktualisierungsHorcher = new GebuehrenStreitwertHorcher(this,
			((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(21001)).getTitle());

	public static final String FEHLER_DRUCKEN = "Fehler beim Drucken";
	public static final int FTF_STREITWERT = 5;
	public static final int TABLE_GEBUEHREN = 8;
	private JLabel lblStreitwert;
	private ParsendUndBauend<GebuehrenBerechnung> pruefer = new GebuehrenBerechnungParser();
	private GebuehrenBerechnungAufrufHorcher aufrufHorcher;

	/**
	 * Der Konstruktor ruft nur die Oberklasse auf.
	 * 
	 */
	private GebuehrenBerechnungPanel() {
		super();
	}

	/**
	 * Das Panel ist als Singelton ausgestatltet. Diese Methode gibt die alleinige
	 * Instanz zurück.
	 * 
	 * @return gibt {@link #instance} als GebuehrenBerechnungPanel zurück.
	 */
	public static GebuehrenBerechnungPanel getInstance() {
		return instance;
	}

	/**
	 * Die Methode fuellt den GebuehrenRechnerPanel.
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JPanel pnStreitwert = super.addNewPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(21000),
				new GridBagLayout());// .createPanel
//		lblStreitwert = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(21001), pnStreitwert);
//		lblStreitwert.setHorizontalAlignment(SwingConstants.RIGHT);
		setFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT,
				(JFormattedTextField) beschrifter.beschrifteGemeinsam(lblStreitwert = new JLabel(),
						new JFormattedTextField(KostenJPanel.FORMATTER),
						(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(21005), pnStreitwert));
		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).setColumns(10);
		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).setText("0");
		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT)
				.addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
//		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).setHorizontalAlignment(SwingConstants.RIGHT);
//		lblStreitwert.setLabelFor(getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT));

		// JScrollpane mit Gebührentabelle, die sich mit dem ftf synchronisiert
//		JLabel lblStreitwertTabelle = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(21010), pnStreitwert);
		setTabStreitwertTabelle(
				(JTable) beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(21021)));// swtm
		setAufrufHorcher(new GebuehrenBerechnungAufrufHorcher());
		getTabStreitwertTabelle().setDefaultRenderer(Long.class, KostenJPanel.EURO_RENDERER);
		getTabStreitwertTabelle().setDefaultRenderer(Double.class, KostenJPanel.EURO_RENDERER);
		getTabStreitwertTabelle().getTableHeader().setDefaultRenderer(KostenJPanel.HEADER_RENDERER);
		getTabStreitwertTabelle().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		entferneTastaturFalle(getTabStreitwertTabelle());
//		JScrollPane scpStreitwertTabelle = (JScrollPane) 
		beschrifter.beschrifteGemeinsam(new JScrollPane(getTabStreitwertTabelle()),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(21020), pnStreitwert);
//		lblStreitwertTabelle.setLabelFor(scpStreitwertTabelle);

		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).addFocusListener(aktualisierungsHorcher);
		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).addKeyListener(aktualisierungsHorcher);
		getTabStreitwertTabelle().addFocusListener(aktualisierungsHorcher);
		getTabStreitwertTabelle().addMouseListener(aktualisierungsHorcher);
		getTabStreitwertTabelle().addKeyListener(aktualisierungsHorcher);
		getTabStreitwertTabelle().getSelectionModel().addListSelectionListener(aktualisierungsHorcher);

		// JScrollpane mit JTable mit gttm + JLabel
		// createPanel
		JPanel pnGebuehren = super.addNewPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(22000),
				new GridBagLayout());
//		JLabel lblGebuehrenTatbestaende = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(22001), pnGebuehren);
		tabGebuehrenTatbestaende = (JTable) beschrifter.beschrifte(new JTable(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(22011));
		leereGebuehrenTabellen();
		entferneTastaturFalle(tabGebuehrenTatbestaende);
		setzeGebuehrenTabelleAussehen(tabGebuehrenTatbestaende);
//		JScrollPane scpGebuehrenTatbestaende = (JScrollPane) 
		beschrifter.beschrifteGemeinsam(new JScrollPane(tabGebuehrenTatbestaende),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(22010), pnGebuehren);
//		lblGebuehrenTatbestaende.setLabelFor(scpGebuehrenTatbestaende);

		// JButton Gebühr hinzufügen
//		JButton btnNeueVerguetung = .toButton();
		beschrifter.add((BeschriebeneAktion) neueRvgVerguetungAction, pnGebuehren);
//		JButton btnNeueGebuehr = .toButton()
		beschrifter.add((BeschriebeneAktion) neueGkgGebuehrAction, pnGebuehren);

		JPanel pnAufstellung = super.addNewPanel
		// createPanel
		((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(23000), new GridBagLayout());

		// JTextField Summe berechnen
		tfGebuehrenSumme = (JTextField) beschrifter.beschrifteVergittert(new JTextField(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(23005), pnAufstellung);
		tfGebuehrenSumme.setEditable(false);
//		tfGebuehrenSumme.setHorizontalAlignment(SwingConstants.RIGHT);

		// JButton btnSummeBerechnen = .toButton()
		beschrifter.add((BeschriebeneAktion) gebuehrenAufstellungAction, pnAufstellung);

		errechneGebuehrenSumme();

		// Der JPanel hinzufügen
//		beschrifter.testUnVergittert(pnStreitwert, // .add(
//				lblStreitwert,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// pnStreitwert.add(
//		beschrifter.testUnVergittert(pnStreitwert, getFormattedTextField(FTF_STREITWERT),
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// pnStreitwert.add(
//		beschrifter.testUnVergittert(pnStreitwert, lblStreitwertTabelle,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// pnStreitwert.add(
//		beschrifter.testUnVergittert(pnStreitwert, scpStreitwertTabelle,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 2, 1, GridBagConstraints.BOTH, true));
//		add(
//		beschrifter.testUnVergittert(this, pnStreitwert, GitterBeutelBeschraenkungen.getInstance(0, 0, 2, 3, GridBagConstraints.BOTH, true));

//				.add(
//		beschrifter.testUnVergittert(pnGebuehren, lblGebuehrenTatbestaende,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnGebuehren.add(
//		beschrifter.testUnVergittert(pnGebuehren, scpGebuehrenTatbestaende,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.BOTH, true));
//		pnGebuehren.add(
//		beschrifter.testUnVergittert(pnGebuehren, btnNeueGebuehr,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		pnGebuehren.add(
//		beschrifter.testUnVergittert(pnGebuehren, btnNeueVerguetung,
//				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, pnGebuehren, GitterBeutelBeschraenkungen.getInstance(0, 3, 2, 3, GridBagConstraints.BOTH, true));
// .add(
//		beschrifter.testUnVergittert(pnAufstellung, tfGebuehrenSumme,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		pnAufstellung.add(
//		beschrifter.testUnVergittert(pnAufstellung, btnSummeBerechnen,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, pnAufstellung, GitterBeutelBeschraenkungen.getInstance(0, 6, 2, 2, GridBagConstraints.HORIZONTAL, false));

		// Kontextmenü für Streitwerttabelle
		PopupMenuBuilder builder = new PopupMenuBuilder();
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24100), getTabStreitwertTabelle(),
				new Integer[] { 1 }, (BeschriebeneAktion) druckeSwTabelleAction,
				(BeschriebeneAktion) kopiereSwTabelleAction);

		// Kontextmenü für gttm
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(24200), tabGebuehrenTatbestaende,
				new Integer[] { 1 }, (BeschriebeneAktion) neueGkgGebuehrAction,
				(BeschriebeneAktion) neueRvgVerguetungAction, (BeschriebeneAktion) saeumnisGebuehrenAction,
				(BeschriebeneAktion) anerkenntnisGebuehrenAction, (BeschriebeneAktion) normaleGebuehrenAction,
				(BeschriebeneAktion) mitInstanzGebuehrenAction, (BeschriebeneAktion) eintragEntfernenAktion);

		logDauer();
	}

	/**
	 * Die Methode leert alle Tabellen und sonstige Oberflächenelemente. Damit kann
	 * man dann die Registerkarte initialisieren oder auf den Anfangszustand
	 * zurücksetzen.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	@Override
	public void leereWerte() {
		leereGebuehrenTabellen();
	}

	/**
	 * Die Methode leert die GebuehrenRechnerTabelle, füllt sie mit den Gebühren aus
	 * {@link eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung} und setzt
	 * auch den Streitwert entsprechend.
	 * 
	 * @param container ein
	 *                  {@link eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung}
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setzeWerte(Streitgenossen,
	 *      java.lang.Object)
	 */
	public void setzeWerte(final GebuehrenBerechnung container) {
		/* Erst den Streitwert eintragen und die Tabelle springen lassen */
		getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT).setText(container.streitwert.toString());// (Long.toString((long)
																												// container.streitwert.longValue()));
		aktualisierungsHorcher.focusLost(
				new FocusEvent(getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT), FocusEvent.FOCUS_LOST));
		/* Dann die Tatbestände in die Gebührentabelle eintragen */
		if (gttmRechner == null) {
			gttmRechner = new GebuehrenTableModel(container.gebuehren);
			gttmRechner.addTableModelListener(aktualisierungsHorcher);
			tabGebuehrenTatbestaende.setModel(gttmRechner);
		} else {
			gttmRechner.clear();
			gttmRechner.addAll(container.gebuehren);
		}
	}

	/**
	 * Die Methode dient dazu, eine Referenz auf das Hauptfenster zu übermitteln
	 * 
	 * @param kostenrechner
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 */
	@Override
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * Die Methode addiert die Gebühren der Tabelle.
	 * 
	 */
	public void errechneGebuehrenSumme() {
		String streitwert = "";
		Euro gebuehrenSumme = Euro.ofCents(0L);// double gebuehrenSumme = 0.0;
		if (getFormattedTextField(FTF_STREITWERT) != null && pruefeTabellen()) {
			try {
				streitwert = getFormattedTextField(FTF_STREITWERT).getText();
				gebuehrenSumme = gttmRechner.getValues().errechneGebuehrenSummeMitSteuer(Euro.ofEuros(
						longAusFormatter(getFormattedTextField(FTF_STREITWERT), getLabelText(FTF_STREITWERT))));
			} catch (NumberFormatException e) {
				FehlerHelper.zeigeFehler("Falsches Eingabeformat für den Streitwert: \"" + streitwert + "\"!\n ", e);
			}
		}
		String text = String.format(SUMME_EUR, gebuehrenSumme.doubleValue());
		if (tfGebuehrenSumme != null)
			tfGebuehrenSumme.setText(text);
	}

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return den Untercontainer von
	 *         {@link VerfahrensDatenContainer#gebuehrenBerechnung}
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#baueRueckgabewert()
	 */
	@Override
	public GebuehrenBerechnung baueRueckgabewert() throws NumberFormatException, NullPointerException {
		pruefer.leseComponents(getFormattedTextField(FTF_STREITWERT), tabGebuehrenTatbestaende).parseEingabe();
		return pruefer.getRueckgabewert();
	}

	/**
	 * Die Methode prüft, ob die Gebührentabelle Werte enthält.
	 * 
	 * @return true, wenn Gebührentatbestände in der Tabelle sind.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTableModelHandler#pruefeTabellen()
	 */
	@Override
	public boolean pruefeTabellen() {
		return getTableModel(TABLE_GEBUEHREN) != null && getTableModel(TABLE_GEBUEHREN).getRowCount() > 0;
	}

	/**
	 * @return gibt {@link #tabStreitwertTabelle} als JTable zurück.
	 */
	public JTable getTabStreitwertTabelle() {
		return tabStreitwertTabelle;
	}

	/**
	 * @param tabStreitwertTabelle d. {@link #tabStreitwertTabelle}, d. gesetzt
	 *                             werden soll als JTable
	 */
	public void setTabStreitwertTabelle(JTable tabStreitwertTabelle) {
		this.tabStreitwertTabelle = tabStreitwertTabelle;
	}

	/**
	 * Die Methode dient dazu, das passende {@link JFormattedTextField}
	 * zurückzuliefern
	 * 
	 * @param index ein Bezeichner für das {@link JFormattedTextField}, hier nur
	 *              {@link #TABLE_FTF_GEBUEHREN}
	 * @return gibt das gewählte {@link JFormattedTextField} zurück, hier nur
	 *         {@link #ftfStreitwert}.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getFormattedTextField(int)
	 */
	@Override
	public JFormattedTextField getFormattedTextField(int index) {
		return ftfStreitwert;
	}

	/**
	 * Die Methode soll den Text des zum {@link JFormattedTextField} gehörenden
	 * {@link JLabel}s zurückgeben.
	 * 
	 * @param index ein Bezeichner für das {@link JFormattedTextField}, hier nur
	 *              {@link GebuehrenBerechnungPanel#FTF_STREITWERT}.
	 * @return {@link JLabel#getText()} als String
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getLabelText(int)
	 */
	@Override
	public String getLabelText(int index) {
		if (lblStreitwert != null)
			return lblStreitwert.getText();
		else
			return "";
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

	/**
	 * Die Methode dient dazu, das passende {@link GebuehrenTableModel}
	 * zurückzuliefern
	 * 
	 * @param index ein Bezeichner für das {@link GebuehrenTableModel}, hier nur
	 *              {@link #TABLE_FTF_GEBUEHREN}
	 * @return das gewählte {@link GebuehrenTableModel}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTableModelHandler#getTableModel(int)
	 */
	@Override
	public GebuehrenTableModel getTableModel(int index) {
		if (index != TABLE_GEBUEHREN && Kostenrechner.debug) {
			IllegalArgumentException ie = new IllegalArgumentException(
					String.format("Fehler: index war nicht TABLE_GEBUEHREN, sondern: '%d'!", index));
			FehlerHelper.zeigeFehler(ie.getLocalizedMessage(), ie);
		}
		return gttmRechner;
	}

	/**
	 * 
	 * @param index {@link #TABLE_GEBUEHREN}
	 * @return die in {@link #tabGebuehrenTatbestaende} markierte Zeile oder
	 *         <code>-1</code>, wenn die {@link JTable} <code>null</code> ist oder
	 *         dort keine Zeile markiert ist.
	 * @throws IndexOutOfBoundsException bei einem falschen Wert für
	 *                                   <code>index</code>
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler#getSelectedRow(int)
	 */
	@Override
	public int getSelectedRow(int index) throws IndexOutOfBoundsException {
		if (index != TABLE_GEBUEHREN && Kostenrechner.debug) {
			IllegalArgumentException ie = new IllegalArgumentException(
					String.format("Fehler: index war nicht TABLE_GEBUEHREN, sondern: '%d'!", index));
			FehlerHelper.zeigeFehler(ie.getLocalizedMessage(), ie);
		}
		if (tabGebuehrenTatbestaende != null)
			return tabGebuehrenTatbestaende.getSelectedRow();
		else
			return -1;
	}

	/**
	 * Die Methode dient dazu, dass eine {@link BeschriebeneAktion} den Focus auf
	 * die {@link JComponent} legen kann, die sie aufruft.
	 * 
	 * @return <code>true</code>, wenn der Aufruf wahrscheinlich Erfolg hat;
	 *         <code>false</code>, wenn er zum Scheitern verurteilt ist.
	 * 
	 * @see javax.swing.JComponent#requestFocusInWindow()
	 */
	@Override
	public boolean requestFocusInWindow() {
		getKostenrechner().getTabbedPane().setSelectedComponent(this);
		return super.requestFocusInWindow();
	}

	/**
	 * @return gibt {@link #aufrufHorcher} als
	 *         {@link GebuehrenBerechnungAufrufHorcher} zurück.
	 */
	public GebuehrenBerechnungAufrufHorcher getAufrufHorcher() {
		return aufrufHorcher;
	}

	/**
	 * Die Methode schreibt das {@link StreitwertTableModel} in die
	 * {@link #getTabStreitwertTabelle()}
	 */
	public void initStreitwertTable() {
		getTabStreitwertTabelle().setModel(new StreitwertTableModel());
		getTabStreitwertTabelle().tableChanged(new TableModelEvent(getTabStreitwertTabelle().getModel()));
	}

	/**
	 * Die Methode leert die GebuehrenRechnerTabelle oder füllt sie mit
	 * üblicherweise anfallenden Gebühren, lässt aber die Listener in Ruhe.
	 */
	private void leereGebuehrenTabellen() {
		GebuehrenAuflistung values = new GebuehrenAuflistung();
		if (gttmRechner == null) {
			gttmRechner = new GebuehrenTableModel(values);
			gttmRechner.addTableModelListener(aktualisierungsHorcher);
			tabGebuehrenTatbestaende.setModel(gttmRechner);
		} else {
			gttmRechner.clear();
			gttmRechner.addAll(values);
		}

	}

	/**
	 * @param index         ein Bezeichner für das {@link JFormattedTextField}, hier
	 *                      nur {@link #TABLE_FTF_GEBUEHREN}
	 * @param ftfStreitwert d. {@link #ftfStreitwert}, d. gesetzt werden soll als
	 *                      JFormattedTextField
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#setFormattedTextField(int,
	 *      javax.swing.JFormattedTextField)
	 */
	private void setFormattedTextField(int index, JFormattedTextField ftfStreitwert) {
		this.ftfStreitwert = ftfStreitwert;
	}

	/**
	 * @param aufrufHorcher d. {@link #aufrufHorcher}, d. gesetzt werden soll als
	 *                      {@link GebuehrenBerechnungAufrufHorcher}.
	 */
	private void setAufrufHorcher(GebuehrenBerechnungAufrufHorcher aufrufHorcher) {
		this.aufrufHorcher = aufrufHorcher;
	}

}
