/*
 * AkzeptanzDialog.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.HeadlessException;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.FontHelfer;
import eu.gronos.beschriftungen.view.FontHelferForWindow;
import eu.gronos.kostenrechner.controller.files.HtmlWerkzeugKasten;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Die Klasse ist ein {@link HinzufuegenDialog}, der nach der Zustimmung zur
 * Übersendung von Daten fragt.
 *
 * @author Peter Schuster (setrok)
 * @date 23 Apr 2019
 *
 */
public abstract class AkzeptanzDialog<T> extends HinzufuegenDialog<T> {

	private static final long serialVersionUID = -6845012067282320046L;
	private JTextPane textPane;
	private StyledDocument doc;
	private JScrollPane scrollPane;
	private final HtmlWerkzeugKasten kit = new HtmlWerkzeugKasten();

	/**
	 * Konstruktor: erzeugt eine Instanz der {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner ein {@link JFrame} oder {@link JDialog}
	 * @param title eine {@link Beschriftung} mit dem Titel usw.
	 * @throws HeadlessException
	 */
	public AkzeptanzDialog(Window owner, Beschriftung title) throws HeadlessException {
		super(owner, title);
	}

	/**
	 * Wenn der {@link HinzufuegenDialog#getOkAction() Ok-Button} gedrückt wird, ist
	 * alles gut.
	 * 
	 * {@link HinzufuegenDialog}
	 * 
	 * @return <code>true</code>
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		return true;
	}

	/**
	 * @return gibt {@link #doc} als {@link StyledDocument} zurück.
	 */
	public StyledDocument getDoc() {
		return doc;
	}

	/**
	 * @return
	 * @return gibt {@link #kit} als {@link HtmlWerkzeugKasten} zurück.
	 */
	public HtmlWerkzeugKasten getKit() {
		return kit;
	}

	/**
	 * Die Methode dient dazu, die HTML-Datei einzulesen
	 * 
	 * @param resource der Name der HTML-Datei in den resources
	 */
	public void setHtml(String resource) {
		getKit().read(resource, textPane);
		caretVisible(textPane);
	}

	/**
	 * Die Methode setzt eine {@link JTextPane} mit {@link JScrollPane} ins Fenster
	 * und lädt HTML.
	 * 
	 * @param resource der Name der HTML-Datei in den resources
	 */
	protected void baueTextPane(String resource) {
		textPane = (JTextPane) beschrifter.beschrifte(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(73011));
		textPane.setEditorKit(kit);
		getKit().read(resource, textPane);
		setDoc(textPane.getStyledDocument());
		caretVisible(textPane);

		FontHelferForWindow fufHelfer = new FontHelferForWindow(this);
		fufHelfer.setPreferredSizeFromAttributeSet(getDoc().getParagraphElement(0).getAttributes(),
				FontHelfer.MAX_SPALTEN, FontHelfer.MAX_ZEILEN);
		setScrollPane((JScrollPane) beschrifter.beschrifteVergittert(new JScrollPane(textPane),
				NameContainerSammlung.BESCHRIFTUNGEN.get(73010), contentPanel));
//		.add(,
//		beschrifter.testUnVergittert(contentPanel ,scrollPane,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 3, GridBagConstraints.BOTH, true));
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	}

	/**
	 * @return gibt {@link #scrollPane} als {@link JScrollPane} zurück.
	 */
	protected JScrollPane getScrollPane() {
		return scrollPane;
	}

	/**
	 * @param scrollPane d. {@link #scrollPane}, d. gesetzt werden soll als
	 *                   {@link JScrollPane}.
	 */
	private void setScrollPane(JScrollPane scrollPane) {
		this.scrollPane = scrollPane;
	}

	/**
	 * @param doc d. {@link #doc}, d. gesetzt werden soll als
	 *            {@link StyledDocument}.
	 */
	private void setDoc(StyledDocument doc) {
		this.doc = doc;
	}

}