/**
 * AktionenJMenu.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import javax.swing.AbstractAction;
import javax.swing.Action;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.controller.KostenrechnerBeender;
import eu.gronos.kostenrechner.controller.TabellenZuruecksetzenAction;
import eu.gronos.kostenrechner.controller.files.LadeSkktxAction;
import eu.gronos.kostenrechner.controller.files.SpeichereSkktxAction;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Das Menü Datei stellt die Aktionen für alle möglichen Dateioperationen zu
 * Menüpunkten zusammen.
 *
 * @author Peter Schuster (setrok)
 * @date 20.06.2018
 *
 */
public class DateiJMenu extends KostenJMenu {

	private static final long serialVersionUID = 1481786221712533553L;
	private static final DateiJMenu instance = new DateiJMenu();
	private final AbstractAction tabellenZuruecksetzenAction = new TabellenZuruecksetzenAction(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(61011));
	private Action skktxLaden = new LadeSkktxAction(getKostenrechner(),
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(61021));
	private Action skktxSpeichern = new SpeichereSkktxAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(61041));
	private AbstractAction beendenAction = new KostenrechnerBeender(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(61091));

	/**
	 * Der private Konstruktor hat keine Parameter
	 * 
	 */
	private DateiJMenu() {
		super();
	}

	/**
	 * Die Methode dient dazu, das Dateimenü zusammenzubauen.
	 * 
	 */
	public void buildMenu() {
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		beschrifter.beschrifte(this, NameContainerSammlung.BESCHRIFTUNGEN.get(61000));
		// TODO Tastenkürzel doppelt?
		add(((BeschriebeneAktion) tabellenZuruecksetzenAction).toMenuItem());
		add(((BeschriebeneAktion) skktxLaden).toMenuItem());
		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().xmlLesenAction).toMenuItem());
		add(((BeschriebeneAktion) skktxSpeichern).toMenuItem());
		addSeparator();
		add(((BeschriebeneAktion) getBeendenAction()).toMenuItem());
	}

	/**
	 * @return gibt {@link #instance} als AktionenJMenu zurück.
	 */
	public static DateiJMenu getInstance() {
		return instance;
	}

	/**
	 * @return gibt {@link #beendenAction} als {@link AbstractAction} zurück.
	 */
	public AbstractAction getBeendenAction() {
		return beendenAction;
	}

}
