/**
 * StringButtonRenderer.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.result;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * Rendert Strings als JButton (für Zeilenüberschriftsspalten)
 * 
 * @author Peter Felix Schuster (setrok)
 * @date 23.10.2014
 */
public class StringButtonRenderer extends JButton implements TableCellRenderer {

	private static final long serialVersionUID = 2443639858850355107L;

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		if (value != null)
			if (value instanceof String) {
				setText((String) value);
				setToolTipText((String) value);
			} else
				setText(value.toString());
		else
			setText("");
		Dimension d = getPreferredSize();
		d.height = table.getRowHeight();
		setPreferredSize(d);
		setBorderPainted(false);
		setFocusPainted(false);
		setMargin(new Insets(0, 0, 0, 0));
		if (table.isPaintingForPrint()) {
			setText(getText() + "\t ");
		}
		return this;
	}

}
